/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.base.entity;

import jakarta.persistence.Transient;
import java.util.List;
import lombok.Generated;
import org.miaixz.bus.core.basic.entity.Tracer;
import org.miaixz.bus.core.data.id.ID;
import org.miaixz.bus.core.lang.annotation.Logical;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.FieldKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.validate.magic.annotation.NotBlank;

public class BaseEntity
extends Tracer {
    private static final long serialVersionUID = 2852287773629L;
    @Logical
    @NotBlank
    protected Integer status;
    protected String creator;
    protected Long created;
    protected String modifier;
    protected Long modified;
    @Transient
    protected transient String params;
    @Transient
    @NotBlank
    protected transient Integer pageNo;
    @Transient
    @NotBlank
    protected transient Integer pageSize;
    @Transient
    protected transient String orderBy;

    public static <T extends BaseEntity> void resetIntField(T entity, String[] fields, String[] values) {
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (!"".equals(values[i]) || !FieldKit.hasField(((Object)entity).getClass(), (String)field)) continue;
            MethodKit.invokeSetter(entity, (String)field, null);
        }
    }

    public <T extends BaseEntity> void setAccess(T source, T target) {
        if (ObjectKit.isNull(source) || ObjectKit.isNull(target)) {
            return;
        }
        target.setX_tenant_id(source.getX_tenant_id());
        target.setX_user_id(source.getX_user_id());
    }

    public <T extends BaseEntity> void setAccess(T source, T ... target) {
        if (ObjectKit.isNull(source) || ArrayKit.isEmpty((Object[])target)) {
            return;
        }
        for (T targetEntity : target) {
            this.setAccess(source, targetEntity);
        }
    }

    public <S extends BaseEntity, E extends BaseEntity> void setAccess(S source, List<E> target) {
        if (ObjectKit.isNull(source) || CollKit.isEmpty(target)) {
            return;
        }
        target.forEach(targetEntity -> this.setAccess((BaseEntity)source, (BaseEntity)((Object)targetEntity)));
    }

    public <T> void setInsert(T entity) {
        String id = ObjectKit.isEmpty((Object)this.getValue(entity, "id")) ? ID.objectId() : (String)this.getValue(entity, "id");
        String timestamp = StringKit.toString((Object)DateKit.current());
        String[] fields = new String[]{"id", "created"};
        Object[] value = new Object[]{id, timestamp};
        if (ObjectKit.isEmpty((Object)this.getValue(entity, "creator"))) {
            fields = new String[]{"id", "creator", "created"};
            value = new Object[]{id, ObjectKit.isEmpty((Object)this.getValue(entity, "x_user_id")) ? "-1" : this.getValue(entity, "x_user_id"), timestamp};
        }
        this.setValue(entity, fields, value);
    }

    public <T> void setUpdate(T entity) {
        String timestamp = StringKit.toString((Object)DateKit.current());
        String[] fields = new String[]{"modified"};
        Object[] value = new Object[]{timestamp};
        if (ObjectKit.isEmpty((Object)this.getValue(entity, "modifier"))) {
            fields = new String[]{"modifier", "modified"};
            value = new Object[]{ObjectKit.isEmpty((Object)this.getValue(entity, "x_user_id")) ? "-1" : this.getValue(entity, "x_user_id"), timestamp};
        }
        this.setValue(entity, fields, value);
    }

    public <T> void setValue(T entity) {
        this.setInsert(entity);
        this.setUpdate(entity);
    }

    @Generated
    protected BaseEntity(BaseEntityBuilder<?, ?> b) {
        super(b);
        this.status = b.status;
        this.creator = b.creator;
        this.created = b.created;
        this.modifier = b.modifier;
        this.modified = b.modified;
        this.params = b.params;
        this.pageNo = b.pageNo;
        this.pageSize = b.pageSize;
        this.orderBy = b.orderBy;
    }

    @Generated
    public static BaseEntityBuilder<?, ?> builder() {
        return new BaseEntityBuilderImpl();
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public String getCreator() {
        return this.creator;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getModifier() {
        return this.modifier;
    }

    @Generated
    public Long getModified() {
        return this.modified;
    }

    @Generated
    public String getParams() {
        return this.params;
    }

    @Generated
    public Integer getPageNo() {
        return this.pageNo;
    }

    @Generated
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Generated
    public String getOrderBy() {
        return this.orderBy;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @Generated
    public void setModified(Long modified) {
        this.modified = modified;
    }

    @Generated
    public void setParams(String params) {
        this.params = params;
    }

    @Generated
    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    @Generated
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    @Generated
    public BaseEntity() {
    }

    @Generated
    public BaseEntity(Integer status, String creator, Long created, String modifier, Long modified, String params, Integer pageNo, Integer pageSize, String orderBy) {
        this.status = status;
        this.creator = creator;
        this.created = created;
        this.modifier = modifier;
        this.modified = modified;
        this.params = params;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.orderBy = orderBy;
    }

    @Generated
    public static abstract class BaseEntityBuilder<C extends BaseEntity, B extends BaseEntityBuilder<C, B>>
    extends Tracer.TracerBuilder<C, B> {
        @Generated
        private Integer status;
        @Generated
        private String creator;
        @Generated
        private Long created;
        @Generated
        private String modifier;
        @Generated
        private Long modified;
        @Generated
        private String params;
        @Generated
        private Integer pageNo;
        @Generated
        private Integer pageSize;
        @Generated
        private String orderBy;

        @Generated
        public B status(Integer status) {
            this.status = status;
            return (B)this.self();
        }

        @Generated
        public B creator(String creator) {
            this.creator = creator;
            return (B)this.self();
        }

        @Generated
        public B created(Long created) {
            this.created = created;
            return (B)this.self();
        }

        @Generated
        public B modifier(String modifier) {
            this.modifier = modifier;
            return (B)this.self();
        }

        @Generated
        public B modified(Long modified) {
            this.modified = modified;
            return (B)this.self();
        }

        @Generated
        public B params(String params) {
            this.params = params;
            return (B)this.self();
        }

        @Generated
        public B pageNo(Integer pageNo) {
            this.pageNo = pageNo;
            return (B)this.self();
        }

        @Generated
        public B pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return (B)this.self();
        }

        @Generated
        public B orderBy(String orderBy) {
            this.orderBy = orderBy;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BaseEntity.BaseEntityBuilder(super=" + super.toString() + ", status=" + this.status + ", creator=" + this.creator + ", created=" + this.created + ", modifier=" + this.modifier + ", modified=" + this.modified + ", params=" + this.params + ", pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + ", orderBy=" + this.orderBy + ")";
        }
    }

    @Generated
    private static final class BaseEntityBuilderImpl
    extends BaseEntityBuilder<BaseEntity, BaseEntityBuilderImpl> {
        @Generated
        private BaseEntityBuilderImpl() {
        }

        @Override
        @Generated
        protected BaseEntityBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BaseEntity build() {
            return new BaseEntity(this);
        }
    }
}

