/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.base.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.miaixz.bus.base.entity.BaseEntity;
import org.miaixz.bus.base.mapper.SharedMapper;
import org.miaixz.bus.base.service.SharedService;
import org.miaixz.bus.core.basic.entity.Result;
import org.miaixz.bus.core.basic.normal.Consts;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.mapper.binding.condition.Condition;
import org.miaixz.bus.mapper.binding.condition.ConditionWrapper;
import org.miaixz.bus.mapper.binding.function.Fn;
import org.miaixz.bus.mapper.parsing.ColumnMeta;
import org.miaixz.bus.mapper.parsing.TableMeta;
import org.miaixz.bus.pager.Page;
import org.miaixz.bus.pager.PageContext;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractService<T extends BaseEntity, I extends Serializable, M extends SharedMapper<T, I>>
implements SharedService<T, I> {
    @Autowired
    protected M mapper;

    @Override
    public Object insert(T entity) {
        this.setValue(entity);
        return this.mapper.insert(entity);
    }

    @Override
    public Object insertSelective(T entity) {
        this.setValue(entity);
        return this.mapper.insertSelective(entity);
    }

    @Override
    public List<T> insertBatch(List<T> list) {
        ArrayList data = ListKit.of((Object[])new BaseEntity[0]);
        list.forEach(item -> {
            BaseEntity t = (BaseEntity)((Object)((Object)this.insertSelective((T)item)));
            data.add(t);
        });
        return data;
    }

    @Override
    public List<T> insertBatchSelective(List<T> list) {
        ArrayList data = ListKit.of((Object[])new BaseEntity[0]);
        list.forEach(item -> {
            BaseEntity t = (BaseEntity)((Object)((Object)this.insertSelective((T)item)));
            data.add(t);
        });
        return data;
    }

    @Override
    public Object update(T entity) {
        ((BaseEntity)((Object)entity)).setUpdate(entity);
        return this.mapper.updateByPrimaryKey(entity);
    }

    @Override
    public Object update(T entity, Fn<T, Object> ... fields) {
        ((BaseEntity)((Object)entity)).setUpdate(entity);
        return this.mapper.updateForFieldListByPrimaryKey(entity, Fn.of(fields));
    }

    @Override
    public Object updateSelective(T entity) {
        ((BaseEntity)((Object)entity)).setUpdate(entity);
        return this.mapper.updateByPrimaryKeySelective(entity);
    }

    @Override
    public Object updateSelective(T entity, Fn<T, Object> ... fields) {
        ((BaseEntity)((Object)entity)).setUpdate(entity);
        return this.mapper.updateByPrimaryKeySelectiveWithForceFields(entity, Fn.of(fields));
    }

    @Override
    public Object insertOrUpdate(T entity) {
        if (this.pkHasValue(entity)) {
            return this.update(entity);
        }
        return this.insert(entity);
    }

    @Override
    public Object insertOrUpdateSelective(T entity) {
        if (this.pkHasValue(entity)) {
            return this.updateSelective(entity);
        }
        return this.insertSelective(entity);
    }

    @Override
    public long remove(T entity) {
        ((BaseEntity)((Object)entity)).setStatus(Consts.STATUS_MINUS_ONE);
        ((BaseEntity)((Object)entity)).setUpdate(entity);
        return this.mapper.updateByPrimaryKey(entity);
    }

    @Override
    public long delete(T entity) {
        return this.mapper.delete(entity);
    }

    @Override
    public long deleteById(I id) {
        return this.mapper.deleteByPrimaryKey(id);
    }

    @Override
    public long deleteByIds(Collection<I> ids) {
        return this.deleteByFieldList((Fn & Serializable)entity -> entity.getId(), ids);
    }

    @Override
    public <F> long deleteByFieldList(Fn<T, F> field, Collection<F> fieldValueList) {
        return this.mapper.deleteByFieldList(field, fieldValueList);
    }

    @Override
    public Object selectById(I id) {
        return this.mapper.selectByPrimaryKey(id).orElse(null);
    }

    @Override
    public Object selectOne(T entity) {
        return this.mapper.selectOne(entity).orElse(null);
    }

    @Override
    public List<T> selectList(T entity) {
        return this.mapper.selectList(entity);
    }

    @Override
    public <F> List<T> selectByFieldList(Fn<T, F> field, Collection<F> fieldValueList) {
        return this.mapper.selectByFieldList(field, fieldValueList);
    }

    @Override
    public List<T> selectAll() {
        return this.mapper.selectList(null);
    }

    @Override
    public long count(T entity) {
        return this.mapper.selectCount(entity);
    }

    @Override
    public Condition<T> condition() {
        return SharedService.super.condition();
    }

    @Override
    public long delete(Condition<T> condition) {
        return this.mapper.deleteByCondition(condition);
    }

    @Override
    public long update(T entity, Condition<T> condition) {
        return this.mapper.updateByCondition(entity, condition);
    }

    @Override
    public long updateSelective(T entity, Condition<T> condition) {
        return this.mapper.updateByConditionSelective(entity, condition);
    }

    @Override
    public Object selectOne(Condition<T> condition) {
        return this.mapper.selectOneByCondition(condition).orElse(null);
    }

    @Override
    public Object selectFirst(Condition<T> condition) {
        List list = this.mapper.selectByCondition(condition);
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    @Override
    public List<T> selectList(Condition<T> condition) {
        return this.mapper.selectByCondition(condition);
    }

    @Override
    public long count(Condition<T> condition) {
        return this.mapper.countByCondition(condition);
    }

    @Override
    public boolean pkHasValue(T entity) {
        TableMeta entityTable = this.mapper.entityTable();
        List idColumns = entityTable.idColumns();
        return ((ColumnMeta)idColumns.get(0)).fieldMeta().get(entity) != null;
    }

    @Override
    public Result<T> page(T entity) {
        PageContext.startPage((int)((BaseEntity)((Object)entity)).getPageNo(), (int)((BaseEntity)((Object)entity)).getPageSize());
        if (StringKit.isNotEmpty((CharSequence)((BaseEntity)((Object)entity)).getOrderBy())) {
            PageContext.orderBy((String)((BaseEntity)((Object)entity)).getOrderBy());
        }
        Page list = (Page)this.mapper.selectList(entity);
        return Result.builder().rows(list.getResult()).total(list.getTotal()).build();
    }

    @Override
    public ConditionWrapper<T, I> wrapper() {
        return this.mapper.wrapper();
    }

    protected String setValue(T entity) {
        if (ObjectKit.isEmpty(entity)) {
            return null;
        }
        if (ObjectKit.isEmpty((Object)((BaseEntity)((Object)entity)).getStatus())) {
            ((BaseEntity)((Object)entity)).setStatus(Consts.STATUS_ONE);
        }
        ((BaseEntity)((Object)entity)).setValue(entity);
        return entity.getId();
    }
}

