/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.base.spring;

import org.miaixz.bus.base.service.BaseService;
import org.miaixz.bus.core.basic.normal.ErrorCode;
import org.miaixz.bus.core.basic.normal.Errors;
import org.miaixz.bus.core.basic.spring.Controller;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.validate.magic.annotation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public class BaseController<T, Service extends BaseService<T>>
extends Controller {
    @Autowired
    protected Service service;

    @ResponseBody
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Object add(T entity) {
        Object t = this.service.insertSelective(entity);
        if (ObjectKit.isNotEmpty((Object)t)) {
            return BaseController.write((Object)t);
        }
        return BaseController.write((Errors)ErrorCode._100807);
    }

    @ResponseBody
    @RequestMapping(value={"/remove"}, method={RequestMethod.POST})
    public Object remove(T entity) {
        long total = this.service.remove(entity);
        if (total >= 0L) {
            return BaseController.write((Object)MapKit.of((Object)"total", (Object)total));
        }
        return BaseController.write((Errors)ErrorCode._100807);
    }

    @ResponseBody
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public Object delete(T entity) {
        long total = this.service.delete(entity);
        if (total >= 0L) {
            return BaseController.write((Object)MapKit.of((Object)"total", (Object)total));
        }
        return BaseController.write((Errors)ErrorCode._100807);
    }

    @ResponseBody
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public Object update(T entity) {
        Object t = this.service.updateSelective(entity);
        if (ObjectKit.isNotEmpty((Object)t)) {
            return BaseController.write((Object)t);
        }
        return BaseController.write((Errors)ErrorCode._100807);
    }

    @ResponseBody
    @RequestMapping(value={"/get"}, method={RequestMethod.GET})
    public Object get(T entity) {
        return BaseController.write((Object)this.service.selectOne(entity));
    }

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Object list(T entity) {
        return BaseController.write(this.service.selectList(entity));
    }

    @ResponseBody
    @RequestMapping(value={"/page"}, method={RequestMethod.GET})
    public Object page(@Valid(value={"pageSize", "pageNo"}) T entity) {
        return BaseController.write(this.service.page(entity));
    }
}

