/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.cache.magic.CacheKeys;
import org.miaixz.bus.cache.magic.CachePair;
import org.miaixz.bus.core.annotation.Inject;
import org.miaixz.bus.core.annotation.Singleton;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;

@Singleton
public class Manage {
    private CachePair<String, CacheX> defaultCache;
    private Map<String, CachePair<String, CacheX>> cachePool = new ConcurrentHashMap<String, CachePair<String, CacheX>>();

    @Inject
    public void setCachePool(Map<String, CacheX> caches) {
        Map.Entry<String, CacheX> entry = caches.entrySet().iterator().next();
        this.defaultCache = CachePair.of(entry.getKey(), entry.getValue());
        caches.forEach((name, cache) -> this.cachePool.put((String)name, CachePair.of(name, cache)));
    }

    public Object readSingle(String cache, String key) {
        try {
            CachePair<String, CacheX> cacheImpl = this.getCacheImpl(cache);
            long start = System.currentTimeMillis();
            Object result = cacheImpl.getRight().read(key);
            Logger.info((String)"cache [{}] read single cost: [{}] ms", (Object[])new Object[]{cacheImpl.getLeft(), System.currentTimeMillis() - start});
            return result;
        }
        catch (Throwable e) {
            Logger.error((String)"read single cache failed, key: {} ", (Object[])new Object[]{key, e});
            return null;
        }
    }

    public void writeSingle(String cache, String key, Object value, int expire) {
        if (null != value) {
            try {
                CachePair<String, CacheX> cacheImpl = this.getCacheImpl(cache);
                long start = System.currentTimeMillis();
                cacheImpl.getRight().write(key, value, expire);
                Logger.info((String)"cache [{}] write single cost: [{}] ms", (Object[])new Object[]{cacheImpl.getLeft(), System.currentTimeMillis() - start});
            }
            catch (Throwable e) {
                Logger.error((String)"write single cache failed, key: {} ", (Object[])new Object[]{key, e});
            }
        }
    }

    public CacheKeys readBatch(String cache, Collection<String> keys) {
        CacheKeys cacheKeys;
        if (keys.isEmpty()) {
            cacheKeys = new CacheKeys();
        } else {
            try {
                CachePair<String, CacheX> cacheImpl = this.getCacheImpl(cache);
                long start = System.currentTimeMillis();
                Map<String, Object> cacheMap = cacheImpl.getRight().read(keys);
                Logger.info((String)"cache [{}] read batch cost: [{}] ms", (Object[])new Object[]{cacheImpl.getLeft(), System.currentTimeMillis() - start});
                LinkedHashMap<String, Object> hitValueMap = new LinkedHashMap<String, Object>();
                LinkedHashSet<String> notHitKeys = new LinkedHashSet<String>();
                for (String key : keys) {
                    Object value = cacheMap.get(key);
                    if (null == value) {
                        notHitKeys.add(key);
                        continue;
                    }
                    hitValueMap.put(key, value);
                }
                cacheKeys = new CacheKeys(hitValueMap, notHitKeys);
            }
            catch (Throwable e) {
                Logger.error((String)"read multi cache failed, keys: {}", (Object[])new Object[]{keys, e});
                cacheKeys = new CacheKeys();
            }
        }
        return cacheKeys;
    }

    public void writeBatch(String cache, Map<String, Object> keyValueMap, int expire) {
        try {
            CachePair<String, CacheX> cacheImpl = this.getCacheImpl(cache);
            long start = System.currentTimeMillis();
            cacheImpl.getRight().write(keyValueMap, expire);
            Logger.info((String)"cache [{}] write batch cost: [{}] ms", (Object[])new Object[]{cacheImpl.getLeft(), System.currentTimeMillis() - start});
        }
        catch (Exception e) {
            Logger.error((String)"write map multi cache failed, keys: {}", (Object[])new Object[]{keyValueMap.keySet(), e});
        }
    }

    public void remove(String cache, String ... keys) {
        if (null != keys && keys.length != 0) {
            try {
                CachePair<String, CacheX> cacheImpl = this.getCacheImpl(cache);
                long start = System.currentTimeMillis();
                cacheImpl.getRight().remove(keys);
                Logger.info((String)"cache [{}] remove cost: [{}] ms", (Object[])new Object[]{cacheImpl.getLeft(), System.currentTimeMillis() - start});
            }
            catch (Throwable e) {
                Logger.error((String)"remove cache failed, keys: {}: ", (Object[])new Object[]{keys, e});
            }
        }
    }

    private CachePair<String, CacheX> getCacheImpl(String cacheName) {
        if (StringKit.isEmpty((CharSequence)cacheName)) {
            return this.defaultCache;
        }
        return this.cachePool.computeIfAbsent(cacheName, key -> {
            throw new InternalException(StringKit.format((CharSequence)"no cache implementation named [%s].", (Object[])new Object[]{key}));
        });
    }
}

