/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache.magic;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.miaixz.bus.cache.Context;
import org.miaixz.bus.cache.Hitting;
import org.miaixz.bus.cache.Manage;
import org.miaixz.bus.cache.magic.AbstractReader;
import org.miaixz.bus.cache.magic.AnnoHolder;
import org.miaixz.bus.cache.magic.CacheKeys;
import org.miaixz.bus.cache.magic.MethodHolder;
import org.miaixz.bus.cache.support.Addables;
import org.miaixz.bus.cache.support.KeyGenerator;
import org.miaixz.bus.cache.support.KeyValue;
import org.miaixz.bus.cache.support.PatternGenerator;
import org.miaixz.bus.cache.support.PreventObjects;
import org.miaixz.bus.core.annotation.Inject;
import org.miaixz.bus.core.annotation.Singleton;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.proxy.invoker.ProxyChain;

@Singleton
public class MultiCacheReader
extends AbstractReader {
    @Inject
    private Manage cacheManager;
    @Inject
    private Context config;
    @Inject(optional=true)
    private Hitting baseHitting;

    private static Map mergeMap(Class<?> resultMapType, Map proceedEntryValueMap, Map<String, Object> key2MultiEntry, Map<String, Object> hitKeyValueMap) {
        Map resultMap = Addables.newMap(resultMapType, proceedEntryValueMap);
        MultiCacheReader.mergeCacheValueToResultMap(resultMap, hitKeyValueMap, key2MultiEntry);
        return resultMap;
    }

    private static Map toMap(Class<?> resultMapType, Map<String, Object> key2MultiEntry, Map<String, Object> hitKeyValueMap) {
        Map resultMap = Addables.newMap(resultMapType, null);
        MultiCacheReader.mergeCacheValueToResultMap(resultMap, hitKeyValueMap, key2MultiEntry);
        return resultMap;
    }

    private static void mergeCacheValueToResultMap(Map resultMap, Map<String, Object> hitKeyValueMap, Map<String, Object> key2MultiEntry) {
        for (Map.Entry<String, Object> entry : hitKeyValueMap.entrySet()) {
            Object inCacheValue = entry.getValue();
            if (PreventObjects.isPrevent(inCacheValue)) continue;
            String cacheKey = entry.getKey();
            Object multiArgEntry = key2MultiEntry.get(cacheKey);
            resultMap.put(multiArgEntry, inCacheValue);
        }
    }

    private static Collection mergeCollection(Class<?> collectionType, Collection proceedCollection, Map<String, Object> hitKeyValueMap) {
        Collection resultCollection = Addables.newCollection(collectionType, proceedCollection);
        MultiCacheReader.mergeCacheValueToResultCollection(resultCollection, hitKeyValueMap);
        return resultCollection;
    }

    private static Collection toCollection(Class<?> collectionType, Map<String, Object> hitKeyValueMap) {
        Collection resultCollection = Addables.newCollection(collectionType, null);
        MultiCacheReader.mergeCacheValueToResultCollection(resultCollection, hitKeyValueMap);
        return resultCollection;
    }

    private static void mergeCacheValueToResultCollection(Collection resultCollection, Map<String, Object> hitKeyValueMap) {
        for (Object inCacheValue : hitKeyValueMap.values()) {
            if (PreventObjects.isPrevent(inCacheValue)) continue;
            resultCollection.add(inCacheValue);
        }
    }

    @Override
    public Object read(AnnoHolder annoHolder, MethodHolder methodHolder, ProxyChain baseInvoker, boolean needWrite) throws Throwable {
        Object result;
        Map[] pair = KeyGenerator.generateMultiKey(annoHolder, baseInvoker.getArguments());
        Map key2MultiEntry = pair[1];
        Set<String> keys = key2MultiEntry.keySet();
        CacheKeys cacheKeys = this.cacheManager.readBatch(annoHolder.getCache(), keys);
        this.doRecord(cacheKeys, annoHolder);
        if (!cacheKeys.getMissKeySet().isEmpty()) {
            result = this.handlePartHit(baseInvoker, cacheKeys, annoHolder, methodHolder, pair, needWrite);
        } else {
            Map<String, Object> keyValueMap = cacheKeys.getHitKeyMap();
            result = this.handleFullHit(baseInvoker, keyValueMap, methodHolder, key2MultiEntry);
        }
        return result;
    }

    private Object handlePartHit(ProxyChain baseInvoker, CacheKeys cacheKeys, AnnoHolder annoHolder, MethodHolder methodHolder, Map[] pair, boolean needWrite) throws Throwable {
        Object result;
        Map multiEntry2Key = pair[0];
        Map key2MultiEntry = pair[1];
        Set<String> missKeys = cacheKeys.getMissKeySet();
        Map<String, Object> hitKeyValueMap = cacheKeys.getHitKeyMap();
        Object[] missArgs = this.toMissArgs(missKeys, key2MultiEntry, baseInvoker.getArguments(), annoHolder.getMultiIndex());
        Object proceed = this.doLogInvoke(() -> baseInvoker.proceed(missArgs));
        if (null != proceed) {
            Class<?> returnType = proceed.getClass();
            methodHolder.setReturnType(returnType);
            if (Map.class.isAssignableFrom(returnType)) {
                Map proceedEntryValueMap = (Map)proceed;
                if (needWrite) {
                    Map<String, Object> keyValueMap = KeyValue.mapToKeyValue(proceedEntryValueMap, missKeys, multiEntry2Key, this.config.getPrevent());
                    this.cacheManager.writeBatch(annoHolder.getCache(), keyValueMap, annoHolder.getExpire());
                }
                result = MultiCacheReader.mergeMap(returnType, proceedEntryValueMap, key2MultiEntry, hitKeyValueMap);
            } else {
                Collection proceedCollection = this.asCollection(proceed, returnType);
                if (needWrite) {
                    Map<String, Object> keyValueMap = KeyValue.collectionToKeyValue(proceedCollection, annoHolder.getId(), missKeys, multiEntry2Key, this.config.getPrevent());
                    this.cacheManager.writeBatch(annoHolder.getCache(), keyValueMap, annoHolder.getExpire());
                }
                Collection resultCollection = MultiCacheReader.mergeCollection(returnType, proceedCollection, hitKeyValueMap);
                result = this.asType(resultCollection, returnType);
            }
        } else {
            result = this.handleFullHit(baseInvoker, hitKeyValueMap, methodHolder, key2MultiEntry);
        }
        return result;
    }

    private Object asType(Collection collection, Class<?> returnType) {
        if (Collection.class.isAssignableFrom(returnType)) {
            return collection;
        }
        return collection.toArray();
    }

    private Collection asCollection(Object proceed, Class<?> returnType) {
        if (Collection.class.isAssignableFrom(returnType)) {
            return (Collection)proceed;
        }
        return Arrays.asList((Object[])proceed);
    }

    private Object handleFullHit(ProxyChain baseInvoker, Map<String, Object> keyValueMap, MethodHolder methodHolder, Map<String, Object> key2Id) throws Throwable {
        Object result;
        Class<?> returnType = methodHolder.getReturnType();
        if (null == returnType) {
            result = this.doLogInvoke(() -> ((ProxyChain)baseInvoker).proceed());
            if (null != result) {
                methodHolder.setReturnType(result.getClass());
            }
        } else {
            result = methodHolder.isCollection() ? MultiCacheReader.toCollection(returnType, keyValueMap) : MultiCacheReader.toMap(returnType, key2Id, keyValueMap);
        }
        return result;
    }

    private Object[] toMissArgs(Set<String> missKeys, Map<String, Object> keyIdMap, Object[] args, int multiIndex) {
        List<Object> missedMultiEntries = missKeys.stream().map(keyIdMap::get).collect(Collectors.toList());
        Class<?> multiArgType = args[multiIndex].getClass();
        Addables.Addable addable = Addables.newAddable(multiArgType, missedMultiEntries.size());
        args[multiIndex] = addable.addAll(missedMultiEntries).getResult();
        return args;
    }

    private void doRecord(CacheKeys cacheKeys, AnnoHolder annoHolder) {
        Set<String> missKeys = cacheKeys.getMissKeySet();
        int hitCount = cacheKeys.getHitKeyMap().size();
        int totalCount = hitCount + missKeys.size();
        Logger.info((String)"multi cache hit rate: {}/{}, missed keys: {}", (Object[])new Object[]{hitCount, totalCount, missKeys});
        if (null != this.baseHitting) {
            String pattern = PatternGenerator.generatePattern(annoHolder);
            this.baseHitting.hitIncr(pattern, hitCount);
            this.baseHitting.reqIncr(pattern, totalCount);
        }
    }
}

