/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache.metric;

import jakarta.annotation.PreDestroy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.cache.serialize.BaseSerializer;
import org.miaixz.bus.cache.serialize.Hessian2Serializer;
import redis.clients.jedis.JedisCluster;

public class RedisClusterCache
implements CacheX {
    private BaseSerializer serializer;
    private JedisCluster jedisCluster;

    public RedisClusterCache(JedisCluster jedisCluster) {
        this(jedisCluster, new Hessian2Serializer());
    }

    public RedisClusterCache(JedisCluster jedisCluster, BaseSerializer serializer) {
        this.jedisCluster = jedisCluster;
        this.serializer = serializer;
    }

    static byte[][] toByteArray(Map<String, Object> keyValueMap, BaseSerializer serializer) {
        byte[][] kvs = new byte[keyValueMap.size() * 2][];
        int index = 0;
        for (Map.Entry<String, Object> entry : keyValueMap.entrySet()) {
            kvs[index++] = entry.getKey().getBytes();
            kvs[index++] = serializer.serialize(entry.getValue());
        }
        return kvs;
    }

    static byte[][] toByteArray(Collection<String> keys) {
        byte[][] array = new byte[keys.size()][];
        int index = 0;
        for (String text : keys) {
            array[index++] = text.getBytes();
        }
        return array;
    }

    static Map<String, Object> toObjectMap(Collection<String> keys, List<byte[]> bytesValues, BaseSerializer serializer) {
        int index = 0;
        HashMap<String, Object> result = new HashMap<String, Object>(keys.size());
        for (String key : keys) {
            Object value = serializer.deserialize(bytesValues.get(index++));
            result.put(key, value);
        }
        return result;
    }

    @Override
    public Object read(String key) {
        return this.serializer.deserialize(this.jedisCluster.get(key.getBytes()));
    }

    @Override
    public void write(String key, Object value, long expire) {
        byte[] bytes = this.serializer.serialize(value);
        if (expire == 0L) {
            this.jedisCluster.set(key.getBytes(), bytes);
        } else {
            this.jedisCluster.setex(key.getBytes(), (long)((int)(expire / 1000L)), bytes);
        }
    }

    @Override
    public Map<String, Object> read(Collection<String> keys) {
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        List bytesValues = this.jedisCluster.mget(RedisClusterCache.toByteArray(keys));
        return RedisClusterCache.toObjectMap(keys, bytesValues, this.serializer);
    }

    @Override
    public void write(Map<String, Object> keyValueMap, long expire) {
        if (keyValueMap.isEmpty()) {
            return;
        }
        if (expire == 0L) {
            this.jedisCluster.mset(RedisClusterCache.toByteArray(keyValueMap, this.serializer));
        } else {
            for (Map.Entry<String, Object> entry : keyValueMap.entrySet()) {
                this.write(entry.getKey(), entry.getValue(), expire);
            }
        }
    }

    @Override
    public void remove(String ... keys) {
        if (keys.length == 0) {
            return;
        }
        this.jedisCluster.del(keys);
    }

    @Override
    public void clear() {
        this.tearDown();
    }

    @PreDestroy
    public void tearDown() {
        if (null != this.jedisCluster) {
            this.jedisCluster.close();
        }
    }
}

