/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache.serialize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.miaixz.bus.cache.serialize.AbstractSerializer;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.logger.Logger;

public class JdkSerializer
extends AbstractSerializer {
    private static void serialize(Serializable object, OutputStream outputStream) {
        if (null == outputStream) {
            throw new IllegalArgumentException("The OutputStream must not be null");
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(outputStream);
            out.writeObject(object);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object deserialize(InputStream inputStream) {
        Object result;
        if (null == inputStream) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(inputStream);
            result = in.readObject();
        }
        catch (IOException | ClassCastException | ClassNotFoundException ce) {
            try {
                throw new InternalException((Throwable)ce);
            }
            catch (Throwable throwable) {
                try {
                    if (null == in) throw throwable;
                    in.close();
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.error((Throwable)e, (String)"close stream failed when deserialize error: ", (Object[])new Object[]{e.getMessage()});
                }
                throw throwable;
            }
        }
        try {
            if (null == in) return result;
            in.close();
            return result;
        }
        catch (IOException e) {
            Logger.error((Throwable)e, (String)"close stream failed when deserialize error: ", (Object[])new Object[]{e.getMessage()});
            return result;
        }
    }

    @Override
    protected byte[] doSerialize(Object object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        JdkSerializer.serialize((Serializable)object, baos);
        return baos.toByteArray();
    }

    @Override
    protected Object doDeserialize(byte[] bytes) {
        if (null == bytes) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        return JdkSerializer.deserialize(new ByteArrayInputStream(bytes));
    }
}

