/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.cache.Complex;
import org.miaixz.bus.cache.Context;
import org.miaixz.bus.cache.Hitting;
import org.miaixz.bus.cache.magic.AbstractReader;
import org.miaixz.bus.cache.magic.MultiCacheReader;
import org.miaixz.bus.cache.magic.SingleCacheReader;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.CollKit;

public class Module
extends AbstractModule {
    private static final AtomicBoolean init = new AtomicBoolean(false);
    private static Injector injector;
    private Context config;

    private Module(Context config) {
        this.config = config;
    }

    public static synchronized Complex coreInstance(Context config) {
        if (init.compareAndSet(false, true)) {
            injector = Guice.createInjector((com.google.inject.Module[])new com.google.inject.Module[]{new Module(config)});
        }
        return (Complex)injector.getInstance(Complex.class);
    }

    protected void configure() {
        Assert.isTrue((null != this.config ? 1 : 0) != 0, (String)"config param can not be null.", (Object[])new Object[0]);
        Assert.isTrue((boolean)CollKit.isNotEmpty(this.config.getCaches()), (String)"caches param can not be empty.", (Object[])new Object[0]);
        this.bind(Context.class).toInstance((Object)this.config);
        MapBinder mapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, CacheX.class);
        this.config.getCaches().forEach((name, cache) -> mapBinder.addBinding(name).toInstance(cache));
        Optional.ofNullable(this.config.getHitting()).ifPresent(mxBean -> this.bind(Hitting.class).toInstance(mxBean));
        this.bind(AbstractReader.class).annotatedWith((Annotation)Names.named((String)"singleCacheReader")).to(SingleCacheReader.class);
        this.bind(AbstractReader.class).annotatedWith((Annotation)Names.named((String)"multiCacheReader")).to(MultiCacheReader.class);
    }
}

