/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache.magic;

import org.miaixz.bus.cache.Context;
import org.miaixz.bus.cache.Hitting;
import org.miaixz.bus.cache.Manage;
import org.miaixz.bus.cache.magic.AbstractReader;
import org.miaixz.bus.cache.magic.AnnoHolder;
import org.miaixz.bus.cache.magic.MethodHolder;
import org.miaixz.bus.cache.support.KeyGenerator;
import org.miaixz.bus.cache.support.PatternGenerator;
import org.miaixz.bus.cache.support.PreventObjects;
import org.miaixz.bus.core.lang.annotation.Inject;
import org.miaixz.bus.core.lang.annotation.Singleton;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.proxy.invoker.ProxyChain;

@Singleton
public class SingleCacheReader
extends AbstractReader {
    @Inject
    private Manage cacheManager;
    @Inject
    private Context config;
    @Inject(optional=true)
    private Hitting baseHitting;

    @Override
    public Object read(AnnoHolder annoHolder, MethodHolder methodHolder, ProxyChain baseInvoker, boolean needWrite) throws Throwable {
        String key = KeyGenerator.generateSingleKey(annoHolder, baseInvoker.getArguments());
        Object readResult = this.cacheManager.readSingle(annoHolder.getCache(), key);
        this.doRecord(readResult, key, annoHolder);
        if (null != readResult) {
            if (PreventObjects.isPrevent(readResult)) {
                return null;
            }
            return readResult;
        }
        Object invokeResult = this.doLogInvoke(() -> ((ProxyChain)baseInvoker).proceed());
        if (null != invokeResult && null == methodHolder.getInnerReturnType()) {
            methodHolder.setInnerReturnType(invokeResult.getClass());
        }
        if (!needWrite) {
            return invokeResult;
        }
        if (null != invokeResult) {
            this.cacheManager.writeSingle(annoHolder.getCache(), key, invokeResult, annoHolder.getExpire());
            return invokeResult;
        }
        if (this.config.isPreventOn()) {
            this.cacheManager.writeSingle(annoHolder.getCache(), key, PreventObjects.getPreventObject(), annoHolder.getExpire());
        }
        return null;
    }

    private void doRecord(Object result, String key, AnnoHolder annoHolder) {
        Logger.info((String)"single cache hit rate: {}/1, key: {}", (Object[])new Object[]{null == result ? 0 : 1, key});
        if (null != this.baseHitting) {
            String pattern = PatternGenerator.generatePattern(annoHolder);
            if (null != result) {
                this.baseHitting.hitIncr(pattern, 1);
            }
            this.baseHitting.reqIncr(pattern, 1);
        }
    }
}

