/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache.provider;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.miaixz.bus.cache.provider.AbstractHitting;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class SqliteHitting
extends AbstractHitting {
    public SqliteHitting(Map<String, Object> context) {
        super(context);
    }

    public SqliteHitting(String url, String username, String password) {
        super(url, username, password);
    }

    @Override
    protected Supplier<JdbcOperations> jdbcOperationsSupplier(Map<String, Object> context) {
        return () -> {
            SingleConnectionDataSource dataSource = new SingleConnectionDataSource();
            dataSource.setDriverClassName("org.sqlite.JDBC");
            dataSource.setUrl((String)context.get("url"));
            JdbcTemplate template = new JdbcTemplate((DataSource)dataSource);
            template.execute("CREATE TABLE IF NOT EXISTS hi_cache_rate(id BIGINT     IDENTITY PRIMARY KEY,pattern       VARCHAR(64) NOT NULL UNIQUE,hit_count     BIGINT      NOT NULL     DEFAULT 0,require_count BIGINT      NOT NULL     DEFAULT 0,version       BIGINT      NOT NULL     DEFAULT 0)");
            return template;
        };
    }

    @Override
    protected Stream<AbstractHitting.DataDO> transferResults(List<Map<String, Object>> mapResults) {
        return mapResults.stream().map(result -> {
            AbstractHitting.DataDO dataDO = new AbstractHitting.DataDO();
            dataDO.setHitCount(((Integer)result.get("hit_count")).intValue());
            dataDO.setPattern((String)result.get("pattern"));
            dataDO.setRequireCount(((Integer)result.get("require_count")).intValue());
            dataDO.setVersion(((Integer)result.get("version")).intValue());
            return dataDO;
        });
    }
}

