/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache.serialize;

import org.miaixz.bus.cache.serialize.BaseSerializer;
import org.miaixz.bus.logger.Logger;

public abstract class AbstractSerializer
implements BaseSerializer {
    protected abstract byte[] doSerialize(Object var1) throws Throwable;

    protected abstract Object doDeserialize(byte[] var1) throws Throwable;

    @Override
    public <T> byte[] serialize(T object) {
        if (null == object) {
            return null;
        }
        try {
            return this.doSerialize(object);
        }
        catch (Throwable t) {
            Logger.error((String)"{} serialize error.", (Object[])new Object[]{this.getClass().getName(), t});
            return null;
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        try {
            return (T)this.doDeserialize(bytes);
        }
        catch (Throwable t) {
            Logger.error((String)"{} deserialize error.", (Object[])new Object[]{this.getClass().getName(), t});
            return null;
        }
    }
}

