/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.miaixz.bus.cache.magic.AnnoHolder;
import org.miaixz.bus.cache.magic.annotation.CacheKey;
import org.miaixz.bus.cache.support.PreventObjects;
import org.miaixz.bus.cache.support.SpelCalculator;
import org.miaixz.bus.core.lang.EnumValue;
import org.miaixz.bus.core.lang.Normal;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;

public class Builder {
    private static final String X_ARGS_PREFIX = "args";
    private static final ConcurrentMap<Method, String> patterns = new ConcurrentHashMap<Method, String>();
    private static String[] X_ARGS = new String[]{"args0", "args1", "args2", "args3", "args4", "args5", "args6", "args7", "args8", "args9", "args10", "args11", "args12", "args13", "args14", "args15", "args16", "args17", "args18", "args19"};
    private static final ConcurrentMap<Method, String[]> methodParameterNames = new ConcurrentHashMap<Method, String[]>();
    private static boolean isFirst = true;

    public static String[] getArgNames(Method method) {
        return methodParameterNames.computeIfAbsent(method, Builder::doGetArgNamesWithJava8);
    }

    public static String[] getXArgNames(int valueSize) {
        if (valueSize == 0) {
            return Normal.EMPTY_STRING_ARRAY;
        }
        String[] xArgs = new String[valueSize];
        for (int i = 0; i < valueSize; ++i) {
            xArgs[i] = i < X_ARGS.length ? X_ARGS[i] : X_ARGS_PREFIX + i;
        }
        return xArgs;
    }

    private static String[] doGetArgNamesWithJava8(Method method) {
        Parameter[] parameters = method.getParameters();
        String[] argNames = (String[])Arrays.stream(parameters).map(Parameter::getName).toArray(String[]::new);
        if (isFirst && argNames.length != 0 && argNames[0].equals("arg0")) {
            Logger.warn((String)"compile not set '\u2013parameters', used default method parameter names", (Object[])new Object[0]);
            isFirst = false;
        }
        return argNames;
    }

    public static String generateSingleKey(AnnoHolder annoHolder, Object[] argValues) {
        String[] argNames = Builder.getArgNames(annoHolder.getMethod());
        Map<Integer, CacheKey> cacheKeyMap = annoHolder.getCacheKeyMap();
        String prefix = annoHolder.getPrefix();
        return Builder.doGenerateKey(cacheKeyMap, prefix, argNames, argValues);
    }

    public static Map[] generateMultiKey(AnnoHolder annoHolder, Object[] argValues) {
        LinkedHashMap multiEntry2Key = new LinkedHashMap();
        LinkedHashMap key2MultiEntry = new LinkedHashMap();
        Collection multiArgEntries = Builder.getMultiArgEntries(argValues[annoHolder.getMultiIndex()]);
        Map<Integer, CacheKey> argIndex2CacheKey = annoHolder.getCacheKeyMap();
        String prefix = annoHolder.getPrefix();
        Object[] argNames = Builder.getArgNames(annoHolder.getMethod());
        String[] appendArgNames = (String[])Builder.appendArray(argNames, "i");
        int i = 0;
        for (Object multiElement : multiArgEntries) {
            Object[] appendArgValues = Builder.appendArray(argValues, i);
            String key = Builder.doGenerateKey(argIndex2CacheKey, prefix, appendArgNames, appendArgValues);
            key2MultiEntry.put(key, multiElement);
            multiEntry2Key.put(multiElement, key);
            ++i;
        }
        return new Map[]{multiEntry2Key, key2MultiEntry};
    }

    private static String doGenerateKey(Map<Integer, CacheKey> parameterIndex2CacheKey, String prefix, String[] argNames, Object[] argValues) {
        StringBuilder sb = new StringBuilder(prefix);
        for (Map.Entry<Integer, CacheKey> entry : parameterIndex2CacheKey.entrySet()) {
            int argIndex = entry.getKey();
            String argSpel = entry.getValue().value();
            Object defaultValue = Builder.getDefaultValue(argValues, argIndex);
            Object keyPart = SpelCalculator.calcSpelValueWithContext(argSpel, argNames, argValues, defaultValue);
            sb.append(keyPart);
        }
        return sb.toString();
    }

    private static Object getDefaultValue(Object[] argValues, int argIndex) {
        return argValues[argIndex];
    }

    private static Collection getMultiArgEntries(Object multiArg) {
        if (null == multiArg) {
            return Collections.emptyList();
        }
        if (multiArg instanceof Collection) {
            return (Collection)multiArg;
        }
        if (multiArg instanceof Map) {
            return ((Map)multiArg).keySet();
        }
        return Arrays.stream((Object[])multiArg).collect(Collectors.toList());
    }

    private static Object[] appendArray(Object[] origin, Object append) {
        Object[] dest = Arrays.copyOf(origin, origin.length + 1);
        dest[origin.length] = append;
        return dest;
    }

    public static Map<String, Object> mapToKeyValue(Map proceedEntryValueMap, Set<String> missKeys, Map<Object, String> multiEntry2Key, EnumValue.Switch prevent) {
        HashMap<String, Object> keyValueMap = new HashMap<String, Object>(proceedEntryValueMap.size());
        proceedEntryValueMap.forEach((multiArgEntry, value) -> {
            String key = (String)multiEntry2Key.get(multiArgEntry);
            if (StringKit.isEmpty((CharSequence)key)) {
                return;
            }
            missKeys.remove(key);
            keyValueMap.put(key, value);
        });
        if (prevent == EnumValue.Switch.ON && !missKeys.isEmpty()) {
            missKeys.forEach(key -> keyValueMap.put((String)key, PreventObjects.getPreventObject()));
        }
        return keyValueMap;
    }

    public static Map<String, Object> collectionToKeyValue(Collection proceedCollection, String idSpel, Set<String> missKeys, Map<Object, String> id2Key, EnumValue.Switch prevent) {
        HashMap<String, Object> keyValueMap = new HashMap<String, Object>(proceedCollection.size());
        for (Object value : proceedCollection) {
            Object id = SpelCalculator.calcSpelWithNoContext(idSpel, value);
            String key2 = id2Key.get(id);
            if (!StringKit.isEmpty((CharSequence)key2)) continue;
            missKeys.remove(key2);
            keyValueMap.put(key2, value);
        }
        if (prevent == EnumValue.Switch.ON && !missKeys.isEmpty()) {
            missKeys.forEach(key -> keyValueMap.put((String)key, PreventObjects.getPreventObject()));
        }
        return keyValueMap;
    }

    public static String generatePattern(AnnoHolder annoHolder) {
        return patterns.computeIfAbsent(annoHolder.getMethod(), method -> Builder.doPatternCombiner(annoHolder));
    }

    private static String doPatternCombiner(AnnoHolder annoHolder) {
        StringBuilder sb = new StringBuilder(annoHolder.getPrefix());
        Collection<CacheKey> cacheKeys = annoHolder.getCacheKeyMap().values();
        for (CacheKey cacheKey : cacheKeys) {
            sb.append(cacheKey.value());
        }
        return sb.toString();
    }
}

