/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.miaixz.bus.cache.Builder;
import org.miaixz.bus.cache.Context;
import org.miaixz.bus.cache.Manage;
import org.miaixz.bus.cache.magic.AnnoHolder;
import org.miaixz.bus.cache.magic.CachePair;
import org.miaixz.bus.cache.magic.MethodHolder;
import org.miaixz.bus.cache.magic.annotation.Cached;
import org.miaixz.bus.cache.magic.annotation.CachedGet;
import org.miaixz.bus.cache.magic.annotation.Invalid;
import org.miaixz.bus.cache.reader.AbstractReader;
import org.miaixz.bus.cache.support.CacheInfoContainer;
import org.miaixz.bus.cache.support.SpelCalculator;
import org.miaixz.bus.core.lang.EnumValue;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.proxy.invoker.ProxyChain;

public class Complex {
    private Context context;
    private Manage manage;
    private AbstractReader singleCacheReader;
    private AbstractReader multiCacheReader;

    public static boolean isSwitchOn(Context config, Cached cached, Method method, Object[] args) {
        return Complex.doIsSwitchOn(config.getCache() == EnumValue.Switch.ON, cached.expire(), cached.condition(), method, args);
    }

    public static boolean isSwitchOn(Context config, Invalid invalid, Method method, Object[] args) {
        return Complex.doIsSwitchOn(config.getCache() == EnumValue.Switch.ON, 0, invalid.condition(), method, args);
    }

    public static boolean isSwitchOn(Context config, CachedGet cachedGet, Method method, Object[] args) {
        return Complex.doIsSwitchOn(config.getCache() == EnumValue.Switch.ON, 0, cachedGet.condition(), method, args);
    }

    public Object read(CachedGet cachedGet, Method method, ProxyChain baseInvoker) throws Throwable {
        Object result = Complex.isSwitchOn(this.context, cachedGet, method, baseInvoker.getArguments()) ? this.doReadWrite(method, baseInvoker, false) : baseInvoker.proceed();
        return result;
    }

    public Object readWrite(Cached cached, Method method, ProxyChain baseInvoker) throws Throwable {
        Object result = Complex.isSwitchOn(this.context, cached, method, baseInvoker.getArguments()) ? this.doReadWrite(method, baseInvoker, true) : baseInvoker.proceed();
        return result;
    }

    public void remove(Invalid invalid, Method method, Object[] args) {
        if (Complex.isSwitchOn(this.context, invalid, method, args)) {
            long start = System.currentTimeMillis();
            AnnoHolder annoHolder = CacheInfoContainer.getCacheInfo(method).getLeft();
            if (annoHolder.isMulti()) {
                Map[] pair = Builder.generateMultiKey(annoHolder, args);
                Set keys = pair[1].keySet();
                this.manage.remove(invalid.value(), keys.toArray(new String[keys.size()]));
                Logger.info((String)"multi cache clear, keys: {}", (Object[])new Object[]{keys});
            } else {
                String key = Builder.generateSingleKey(annoHolder, args);
                this.manage.remove(invalid.value(), key);
                Logger.info((String)"single cache clear, key: {}", (Object[])new Object[]{key});
            }
            Logger.debug((String)"cache clear total cost [{}] ms", (Object[])new Object[]{System.currentTimeMillis() - start});
        }
    }

    public void write() {
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setManage(Manage manage) {
        this.manage = manage;
    }

    public void setSingleCacheReader(AbstractReader singleCacheReader) {
        this.singleCacheReader = singleCacheReader;
    }

    public void setMultiCacheReader(AbstractReader multiCacheReader) {
        this.multiCacheReader = multiCacheReader;
    }

    private static boolean doIsSwitchOn(boolean openStat, int expire, String condition, Method method, Object[] args) {
        if (!openStat) {
            return false;
        }
        if (expire == -1) {
            return false;
        }
        return (Boolean)SpelCalculator.calcSpelValueWithContext(condition, Builder.getArgNames(method), args, true);
    }

    private Object doReadWrite(Method method, ProxyChain baseInvoker, boolean needWrite) throws Throwable {
        long start = System.currentTimeMillis();
        CachePair<AnnoHolder, MethodHolder> pair = CacheInfoContainer.getCacheInfo(method);
        AnnoHolder annoHolder = pair.getLeft();
        MethodHolder methodHolder = pair.getRight();
        Object result = annoHolder.isMulti() ? this.multiCacheReader.read(annoHolder, methodHolder, baseInvoker, needWrite) : this.singleCacheReader.read(annoHolder, methodHolder, baseInvoker, needWrite);
        Logger.debug((String)"cache read total cost [{}] ms", (Object[])new Object[]{System.currentTimeMillis() - start});
        return result;
    }
}

