/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache;

import java.util.Map;

public interface Metrics {
    public void reqIncr(String var1, int var2);

    public void hitIncr(String var1, int var2);

    public Map<String, Snapshot> getHitting();

    public void reset(String var1);

    public void resetAll();

    default public String summaryName() {
        return "zh".equalsIgnoreCase(System.getProperty("user.language")) ? "\u5168\u5c40" : "summary";
    }

    public static class Snapshot {
        private final long hit;
        private final long required;
        private final String rate;

        private Snapshot(long hit, long required, String rate) {
            this.hit = hit;
            this.required = required;
            this.rate = rate;
        }

        public static Snapshot newInstance(long hit, long required) {
            double rate = required == 0L ? 0.0 : (double)hit * 100.0 / (double)required;
            String rateStr = String.format("%.1f%s", rate, "%");
            return new Snapshot(hit, required, rateStr);
        }

        public static Snapshot mergeShootingDO(Snapshot do1, Snapshot do2) {
            long hit = do1.getHit() + do2.getHit();
            long required = do1.getRequired() + do2.getRequired();
            return Snapshot.newInstance(hit, required);
        }

        public long getHit() {
            return this.hit;
        }

        public long getRequired() {
            return this.required;
        }

        public String getRate() {
            return this.rate;
        }
    }
}

