/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.cache.Complex;
import org.miaixz.bus.cache.Context;
import org.miaixz.bus.cache.Manage;
import org.miaixz.bus.cache.Metrics;
import org.miaixz.bus.cache.reader.AbstractReader;
import org.miaixz.bus.cache.reader.MultiCacheReader;
import org.miaixz.bus.cache.reader.SingleCacheReader;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.logger.Logger;

public class Module {
    private Complex complex;
    private Context context;
    private Map<String, CacheX> caches;
    private Metrics metrics;
    private AbstractReader singleCacheReader;
    private AbstractReader multiCacheReader;
    private Manage manage;
    private boolean initialized = false;

    private Module() {
    }

    private static Module getInstance() {
        return ModuleHolder.INSTANCE;
    }

    public static synchronized Complex instance(Context config) {
        Module module = Module.getInstance();
        if (!module.initialized) {
            module.initialize(config);
            module.initialized = true;
            Logger.info((String)"Cache factory initialized successfully", (Object[])new Object[0]);
        }
        return module.complex;
    }

    private void initialize(Context config) {
        Assert.isTrue((null != config ? 1 : 0) != 0, (String)"context param can not be null.", (Object[])new Object[0]);
        Assert.isTrue((boolean)CollKit.isNotEmpty(config.getCaches()), (String)"caches param can not be empty.", (Object[])new Object[0]);
        this.context = config;
        this.caches = Collections.unmodifiableMap(new HashMap<String, CacheX>(config.getCaches()));
        Logger.debug((String)"Initialized caches with size: {}", (Object[])new Object[]{this.caches.size()});
        this.metrics = config.getHitting();
        Logger.debug((String)"Initialized hitting: {}", (Object[])new Object[]{this.metrics != null ? this.metrics.getClass().getSimpleName() : "null"});
        this.singleCacheReader = new SingleCacheReader();
        this.multiCacheReader = new MultiCacheReader();
        Logger.debug((String)"Initialized singleCacheReader and multiCacheReader", (Object[])new Object[0]);
        this.manage = new Manage(this.caches, this.metrics);
        Logger.debug((String)"Initialized manage", (Object[])new Object[0]);
        this.complex = new Complex();
        this.complex.setContext(this.context);
        this.complex.setManage(this.manage);
        this.complex.setSingleCacheReader(this.singleCacheReader);
        this.complex.setMultiCacheReader(this.multiCacheReader);
        Logger.debug((String)"Complex instance created and dependencies set", (Object[])new Object[0]);
    }

    public CacheX getCache(String name) {
        if (this.caches == null) {
            Logger.error((String)"CacheFactory not initialized", (Object[])new Object[0]);
            throw new IllegalStateException("CacheFactory not initialized");
        }
        CacheX cache = this.caches.get(name);
        Logger.debug((String)"Retrieved cache: {} for name: {}", (Object[])new Object[]{cache != null ? cache.getClass().getSimpleName() : "null", name});
        return cache;
    }

    public Optional<Metrics> getHitting() {
        Logger.debug((String)"Retrieved hitting: {}", (Object[])new Object[]{this.metrics != null ? this.metrics.getClass().getSimpleName() : "null"});
        return Optional.ofNullable(this.metrics);
    }

    public AbstractReader getSingleCacheReader() {
        if (this.singleCacheReader == null) {
            Logger.error((String)"CacheFactory not initialized", (Object[])new Object[0]);
            throw new IllegalStateException("CacheFactory not initialized");
        }
        Logger.debug((String)"Retrieved singleCacheReader", (Object[])new Object[0]);
        return this.singleCacheReader;
    }

    public AbstractReader getMultiCacheReader() {
        if (this.multiCacheReader == null) {
            Logger.error((String)"CacheFactory not initialized", (Object[])new Object[0]);
            throw new IllegalStateException("CacheFactory not initialized");
        }
        Logger.debug((String)"Retrieved multiCacheReader", (Object[])new Object[0]);
        return this.multiCacheReader;
    }

    private static class ModuleHolder {
        private static final Module INSTANCE = new Module();

        private ModuleHolder() {
        }
    }
}

