/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache.magic;

import java.lang.reflect.Method;
import java.util.Map;
import org.miaixz.bus.cache.magic.annotation.CacheKey;

public class AnnoHolder {
    private final Method method;
    private final String cache;
    private final String prefix;
    private final int expire;
    private final Map<Integer, CacheKey> cacheKeyMap;
    private final int multiIndex;
    private final String id;

    private AnnoHolder(Method method, String cache, String prefix, int expire, Map<Integer, CacheKey> cacheKeyMap, int multiIndex, String id) {
        this.method = method;
        this.cache = cache;
        this.prefix = prefix;
        this.expire = expire;
        this.cacheKeyMap = cacheKeyMap;
        this.multiIndex = multiIndex;
        this.id = id;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getCache() {
        return this.cache;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getExpire() {
        return this.expire;
    }

    public Map<Integer, CacheKey> getCacheKeyMap() {
        return this.cacheKeyMap;
    }

    public int getMultiIndex() {
        return this.multiIndex;
    }

    public boolean isMulti() {
        return this.multiIndex != -1;
    }

    public String getId() {
        return this.id;
    }

    public static class Builder {
        private Method method;
        private String cache;
        private String prefix;
        private int expire;
        private Map<Integer, CacheKey> cacheKeyMap;
        private int multiIndex = -1;
        private String id;

        private Builder(Method method) {
            this.method = method;
        }

        public static Builder newBuilder(Method method) {
            return new Builder(method);
        }

        public Builder setCache(String cache) {
            this.cache = cache;
            return this;
        }

        public Builder setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder setExpire(int expire) {
            this.expire = expire;
            return this;
        }

        public Builder setMultiIndex(int multiIndex) {
            this.multiIndex = multiIndex;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setCacheKeyMap(Map<Integer, CacheKey> cacheKeyMap) {
            this.cacheKeyMap = cacheKeyMap;
            return this;
        }

        public AnnoHolder build() {
            return new AnnoHolder(this.method, this.cache, this.prefix, this.expire, this.cacheKeyMap, this.multiIndex, this.id);
        }
    }
}

