/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache.metric;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.xyz.StringKit;

public class CaffeineCache<K, V>
implements CacheX<K, V> {
    private LoadingCache<K, V> cache;

    public CaffeineCache(long size, long expire) {
        this.cache = Caffeine.newBuilder().maximumSize(size).expireAfterWrite(expire, TimeUnit.MILLISECONDS).build(key -> null);
    }

    public CaffeineCache(Properties properties) {
        String prefix = StringKit.isNotEmpty((CharSequence)properties.getProperty("prefix")) ? properties.getProperty("prefix") : "";
        String maximumSize = properties.getProperty(prefix + "maximumSize");
        String expireAfterAccess = properties.getProperty(prefix + "expireAfterAccess");
        String expireAfterWrite = properties.getProperty(prefix + "expireAfterWrite");
        String initialCapacity = properties.getProperty(prefix + "initialCapacity");
        this.cache = Caffeine.newBuilder().maximumSize(StringKit.isNotEmpty((CharSequence)maximumSize) ? Long.parseLong(maximumSize) : 1000L).expireAfterAccess(Long.parseLong(expireAfterAccess), TimeUnit.MILLISECONDS).expireAfterWrite(Long.parseLong(expireAfterWrite), TimeUnit.MILLISECONDS).initialCapacity(Integer.parseInt(initialCapacity)).build(key -> null);
    }

    public CaffeineCache(long size, long expire, CacheLoader<K, V> cacheLoader) {
        this.cache = Caffeine.newBuilder().maximumSize(size).expireAfterWrite(expire, TimeUnit.MILLISECONDS).build(cacheLoader);
    }

    @Override
    public V read(K key) {
        return (V)this.cache.getIfPresent(key);
    }

    @Override
    public Map<K, V> read(Collection<K> keys) {
        return this.cache.getAllPresent(keys);
    }

    @Override
    public void write(K key, V value, long expire) {
        this.cache.put(key, value);
    }

    @Override
    public void write(Map<K, V> keyValueMap, long expire) {
        this.cache.putAll(keyValueMap);
    }

    @Override
    public void remove(K ... keys) {
        this.cache.invalidateAll(Arrays.asList(keys));
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    public String getStats() {
        return this.cache.stats().toString();
    }

    public long estimatedSize() {
        return this.cache.estimatedSize();
    }

    public Cache<K, V> getNativeCache() {
        return this.cache;
    }
}

