/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache.metric;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.xyz.StringKit;

public class GuavaCache<K, V>
implements CacheX<K, V> {
    private LoadingCache<K, V> cache;

    public GuavaCache(long size, long expire) {
        this.cache = CacheBuilder.newBuilder().maximumSize(size).expireAfterWrite(expire, TimeUnit.MILLISECONDS).build(new CacheLoader<K, V>(this){

            public Object load(Object key) {
                return null;
            }
        });
    }

    public GuavaCache(Properties properties) {
        String prefix = StringKit.isNotEmpty((CharSequence)properties.getProperty("prefix")) ? properties.getProperty("prefix") : "";
        String maximumSize = properties.getProperty(prefix + "maximumSize");
        String expireAfterAccess = properties.getProperty(prefix + "expireAfterAccess");
        String expireAfterWrite = properties.getProperty(prefix + "expireAfterWrite");
        String initialCapacity = properties.getProperty(prefix + "initialCapacity");
        this.cache = CacheBuilder.newBuilder().maximumSize(StringKit.isNotEmpty((CharSequence)maximumSize) ? Long.parseLong(maximumSize) : 1000L).expireAfterAccess(Long.parseLong(expireAfterAccess), TimeUnit.MILLISECONDS).expireAfterWrite(Long.parseLong(expireAfterWrite), TimeUnit.MILLISECONDS).initialCapacity(Integer.parseInt(initialCapacity)).build(new CacheLoader<K, V>(this){

            public Object load(Object key) {
                return null;
            }
        });
    }

    public GuavaCache(long size, long expire, CacheLoader<K, V> cacheLoader) {
        this.cache = CacheBuilder.newBuilder().maximumSize(size).expireAfterWrite(expire, TimeUnit.MILLISECONDS).build(cacheLoader);
    }

    @Override
    public V read(K key) {
        return (V)this.cache.getIfPresent(key);
    }

    @Override
    public Map<K, V> read(Collection<K> keys) {
        return this.cache.getAllPresent(keys);
    }

    @Override
    public void write(K key, V value, long expire) {
        this.cache.put(key, value);
    }

    @Override
    public void write(Map<K, V> keyValueMap, long expire) {
        this.cache.putAll(keyValueMap);
    }

    @Override
    public void remove(K ... keys) {
        this.cache.invalidateAll(Arrays.asList(keys));
    }

    @Override
    public void clear() {
        this.cache.cleanUp();
    }
}

