/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache.metric;

import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.cache.support.serialize.BaseSerializer;
import org.miaixz.bus.cache.support.serialize.Hessian2Serializer;

public class MemcachedCache<K, V>
implements CacheX<K, V> {
    private static final int _30_DAYS = 2592000;
    private MemcachedClient client;
    private BaseSerializer serializer;

    public MemcachedCache(String ipPorts) throws IOException {
        this(ipPorts, new Hessian2Serializer());
    }

    public MemcachedCache(String addressList, BaseSerializer serializer) throws IOException {
        this.client = new XMemcachedClientBuilder(addressList).build();
        this.serializer = serializer;
    }

    @Override
    public V read(K key) {
        try {
            byte[] bytes = (byte[])this.client.get((String)key);
            return (V)this.serializer.deserialize(bytes);
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(K key, V value, long expire) {
        byte[] byteValue = this.serializer.serialize(value);
        try {
            if (expire == 0L) {
                this.client.set((String)key, 2592000, (Object)byteValue);
            } else {
                this.client.set((String)key, (int)(expire / 1000L), (Object)byteValue);
            }
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<K, V> read(Collection<K> keys) {
        try {
            Map byteMap = this.client.get(keys);
            HashMap resultMap = new HashMap(byteMap.size());
            for (Map.Entry entry : byteMap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = this.serializer.deserialize((byte[])entry.getValue());
                resultMap.put(key, value);
            }
            return resultMap;
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(Map<K, V> keyValueMap, long expire) {
        for (Map.Entry<K, V> entry : keyValueMap.entrySet()) {
            this.write(entry.getKey(), entry.getValue(), expire);
        }
    }

    @Override
    public void remove(K ... keys) {
        try {
            for (K key : keys) {
                this.client.delete((String)key);
            }
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() {
        try {
            this.client.flushAll();
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    public void tearDown() {
        if (null != this.client && !this.client.isShutdown()) {
            try {
                this.client.shutdown();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

