/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache.metric;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.miaixz.bus.cache.CacheX;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.StringKit;

public class MemoryCache<K, V>
implements CacheX<K, V> {
    public static long timeout = 3600000L;
    public static boolean schedulePrune = true;
    private final Map<K, CacheState> map;
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock(true);
    private final Lock writeLock = this.cacheLock.writeLock();
    private final Lock readLock = this.cacheLock.readLock();
    private final long maximumSize;
    private final long expireAfterAccess;
    private final long expireAfterWrite;
    private final AtomicLong requestCount = new AtomicLong();
    private final AtomicLong hitCount = new AtomicLong();

    public MemoryCache() {
        this.map = new ConcurrentHashMap<K, CacheState>(16);
        this.maximumSize = 1000L;
        this.expireAfterWrite = timeout;
        this.expireAfterAccess = 0L;
        if (schedulePrune) {
            this.schedulePrune(timeout);
        }
    }

    public MemoryCache(long size, long expire) {
        this.map = new ConcurrentHashMap<K, CacheState>(16);
        this.maximumSize = size;
        this.expireAfterWrite = expire;
        this.expireAfterAccess = 0L;
        if (schedulePrune) {
            this.schedulePrune(expire);
        }
    }

    public MemoryCache(Properties properties) {
        String prefix = StringKit.isNotEmpty((CharSequence)properties.getProperty("prefix")) ? properties.getProperty("prefix") : "";
        String maximumSize = properties.getProperty(prefix + "maximumSize");
        String expireAfterAccess = properties.getProperty(prefix + "expireAfterAccess");
        String expireAfterWrite = properties.getProperty(prefix + "expireAfterWrite");
        String initialCapacity = properties.getProperty(prefix + "initialCapacity");
        this.maximumSize = StringKit.isNotEmpty((CharSequence)maximumSize) ? Long.parseLong(maximumSize) : 1000L;
        this.expireAfterWrite = StringKit.isNotEmpty((CharSequence)expireAfterWrite) ? Long.parseLong(expireAfterWrite) : timeout;
        this.expireAfterAccess = StringKit.isNotEmpty((CharSequence)expireAfterAccess) ? Long.parseLong(expireAfterAccess) : 0L;
        int initCapacity = StringKit.isNotEmpty((CharSequence)initialCapacity) ? Integer.parseInt(initialCapacity) : 16;
        this.map = new ConcurrentHashMap<K, CacheState>(initCapacity);
        if (schedulePrune) {
            this.schedulePrune(Math.min(this.expireAfterWrite, this.expireAfterAccess > 0L ? this.expireAfterAccess : Long.MAX_VALUE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V read(K key) {
        this.readLock.lock();
        try {
            this.requestCount.incrementAndGet();
            CacheState cacheState = this.map.get(key);
            if (cacheState == null || cacheState.isExpired(this.expireAfterWrite, this.expireAfterAccess)) {
                V v = null;
                return v;
            }
            cacheState.updateAccessTime();
            this.hitCount.incrementAndGet();
            Object object = cacheState.getState();
            return (V)object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Map<K, V> read(Collection<K> keys) {
        HashMap<K, V> subCache = new HashMap<K, V>(keys.size());
        for (K key : keys) {
            subCache.put(key, this.read(key));
        }
        return subCache;
    }

    @Override
    public void write(Map<K, V> keyValueMap, long expire) {
        if (MapKit.isNotEmpty(keyValueMap)) {
            keyValueMap.forEach((key, value) -> this.write(key, value, expire));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(K key, V value, long expire) {
        this.writeLock.lock();
        try {
            if ((long)this.map.size() >= this.maximumSize && !this.map.containsKey(key)) {
                this.evictOldest();
            }
            this.map.put(key, new CacheState(value, expire));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(K key) {
        this.readLock.lock();
        try {
            CacheState cacheState = this.map.get(key);
            boolean bl = cacheState != null && !cacheState.isExpired(this.expireAfterWrite, this.expireAfterAccess);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            Iterator<Map.Entry<K, CacheState>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, CacheState> entry = iterator.next();
                if (!entry.getValue().isExpired(this.expireAfterWrite, this.expireAfterAccess)) continue;
                iterator.remove();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K ... keys) {
        this.writeLock.lock();
        try {
            for (K key : keys) {
                this.map.remove(key);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void schedulePrune(long delay) {
        CacheScheduler.INSTANCE.schedule(this::clear, delay);
    }

    public String getStats() {
        long requests = this.requestCount.get();
        long hits = this.hitCount.get();
        double hitRate = requests == 0L ? 0.0 : (double)hits / (double)requests;
        return String.format("MemoryCacheStats[requests=%d, hits=%d, hitRate=%.2f%%, size=%d]", requests, hits, hitRate * 100.0, this.map.size());
    }

    public long estimatedSize() {
        return this.map.size();
    }

    public Map<K, CacheState> getNativeCache() {
        return this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictOldest() {
        this.writeLock.lock();
        try {
            Map.Entry<K, CacheState> oldest = null;
            long oldestTime = Long.MAX_VALUE;
            for (Map.Entry<K, CacheState> entry : this.map.entrySet()) {
                long writeTime = entry.getValue().getWriteTime();
                if (writeTime >= oldestTime) continue;
                oldestTime = writeTime;
                oldest = entry;
            }
            if (oldest != null) {
                this.map.remove(oldest.getKey());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static class CacheState
    implements Serializable {
        private Object state;
        private final long writeTime;
        private long lastAccessTime;
        private final long expireAfterWrite;

        CacheState(Object state, long expire) {
            this.state = state;
            this.lastAccessTime = this.writeTime = System.currentTimeMillis();
            this.expireAfterWrite = this.writeTime + expire;
        }

        void updateAccessTime() {
            this.lastAccessTime = System.currentTimeMillis();
        }

        boolean isExpired(long expireAfterWrite, long expireAfterAccess) {
            long currentTime = System.currentTimeMillis();
            if (expireAfterWrite > 0L && currentTime > this.expireAfterWrite) {
                return true;
            }
            return expireAfterAccess > 0L && currentTime > this.lastAccessTime + expireAfterAccess;
        }

        @Generated
        public Object getState() {
            return this.state;
        }

        @Generated
        public long getWriteTime() {
            return this.writeTime;
        }

        @Generated
        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        @Generated
        public long getExpireAfterWrite() {
            return this.expireAfterWrite;
        }

        @Generated
        public void setState(Object state) {
            this.state = state;
        }

        @Generated
        public void setLastAccessTime(long lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
        }
    }

    static enum CacheScheduler {
        INSTANCE;

        private AtomicInteger cacheTaskNumber = new AtomicInteger(1);
        private ScheduledExecutorService scheduler;

        private CacheScheduler() {
            this.of();
        }

        private void of() {
            this.shutdown();
            this.scheduler = new ScheduledThreadPoolExecutor(10, r -> new Thread(r, String.format("Cache-Task-%s", this.cacheTaskNumber.getAndIncrement())));
        }

        public void shutdown() {
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
        }

        public void schedule(Runnable task, long delay) {
            this.scheduler.scheduleAtFixedRate(task, delay, delay, TimeUnit.MILLISECONDS);
        }
    }
}

