/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache.reader;

import org.miaixz.bus.cache.Builder;
import org.miaixz.bus.cache.magic.AnnoHolder;
import org.miaixz.bus.cache.magic.MethodHolder;
import org.miaixz.bus.cache.reader.AbstractReader;
import org.miaixz.bus.cache.support.PreventObjects;
import org.miaixz.bus.core.lang.annotation.Singleton;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.proxy.invoker.ProxyChain;

@Singleton
public class SingleCacheReader
extends AbstractReader {
    @Override
    public Object read(AnnoHolder annoHolder, MethodHolder methodHolder, ProxyChain baseInvoker, boolean needWrite) throws Throwable {
        String key = Builder.generateSingleKey(annoHolder, baseInvoker.getArguments());
        Object readResult = this.manage.readSingle(annoHolder.getCache(), key);
        this.doRecord(readResult, key, annoHolder);
        if (null != readResult) {
            if (PreventObjects.isPrevent(readResult)) {
                return null;
            }
            return readResult;
        }
        Object invokeResult = this.doLogInvoke(() -> ((ProxyChain)baseInvoker).proceed());
        if (null != invokeResult && null == methodHolder.getInnerReturnType()) {
            methodHolder.setInnerReturnType(invokeResult.getClass());
        }
        if (!needWrite) {
            return invokeResult;
        }
        if (null != invokeResult) {
            this.manage.writeSingle(annoHolder.getCache(), key, invokeResult, annoHolder.getExpire());
            return invokeResult;
        }
        if (this.context.isPreventOn()) {
            this.manage.writeSingle(annoHolder.getCache(), key, PreventObjects.getPreventObject(), annoHolder.getExpire());
        }
        return null;
    }

    private void doRecord(Object result, String key, AnnoHolder annoHolder) {
        Logger.info((String)"single cache hit rate: {}/1, key: {}", (Object[])new Object[]{null == result ? 0 : 1, key});
        if (null != this.metrics) {
            String pattern = Builder.generatePattern(annoHolder);
            if (null != result) {
                this.metrics.hitIncr(pattern, 1);
            }
            this.metrics.reqIncr(pattern, 1);
        }
    }
}

