/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache.support.metrics;

import jakarta.annotation.PreDestroy;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.miaixz.bus.cache.support.metrics.AbstractMetrics;
import org.miaixz.bus.core.xyz.StringKit;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class H2Metrics
extends AbstractMetrics {
    public H2Metrics(Map<String, Object> context) {
        super(context);
    }

    public H2Metrics(String url, String username, String password) {
        super(url, username, password);
    }

    @Override
    protected Supplier<JdbcOperations> jdbcOperationsSupplier(Map<String, Object> context) {
        return () -> {
            SingleConnectionDataSource dataSource = new SingleConnectionDataSource();
            dataSource.setDriverClassName("org.h2.Driver");
            dataSource.setUrl(StringKit.toString(context.get("url")));
            dataSource.setUsername(StringKit.toString(context.get("username")));
            dataSource.setPassword(StringKit.toString(context.get("password")));
            JdbcTemplate template = new JdbcTemplate((DataSource)dataSource);
            template.execute("CREATE TABLE IF NOT EXISTS t_cache_rate(id BIGINT     IDENTITY PRIMARY KEY,pattern       VARCHAR(64) NOT NULL UNIQUE,hit_count     BIGINT      NOT NULL     DEFAULT 0,require_count BIGINT      NOT NULL     DEFAULT 0,version       BIGINT      NOT NULL     DEFAULT 0)");
            return template;
        };
    }

    @Override
    protected Stream<AbstractMetrics.DataDO> transferResults(List<Map<String, Object>> mapResults) {
        return mapResults.stream().map(map -> {
            AbstractMetrics.DataDO dataDO = new AbstractMetrics.DataDO();
            dataDO.setPattern((String)map.get("PATTERN"));
            dataDO.setHitCount((Long)map.get("HIT_COUNT"));
            dataDO.setRequireCount((Long)map.get("REQUIRE_COUNT"));
            dataDO.setVersion((Long)map.get("VERSION"));
            return dataDO;
        });
    }

    @Override
    @PreDestroy
    public void tearDown() {
        super.tearDown();
    }
}

