/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.cache.support.metrics;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.miaixz.bus.cache.support.metrics.AbstractMetrics;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;

public class MySQLMetrics
extends AbstractMetrics {
    public MySQLMetrics(Map<String, Object> context) {
        super(context);
    }

    public MySQLMetrics(String url, String username, String password) {
        super(url, username, password);
    }

    @Override
    protected Supplier<JdbcOperations> jdbcOperationsSupplier(Map<String, Object> context) {
        return () -> {
            try {
                Properties properties = new Properties();
                for (String key : context.keySet()) {
                    properties.setProperty(key, context.get(key).toString());
                }
                HikariDataSource dataSource = new HikariDataSource(new HikariConfig(properties));
                JdbcTemplate template = new JdbcTemplate((DataSource)dataSource);
                template.execute("CREATE TABLE IF NOT EXISTS t_cache_rate(id BIGINT     PRIMARY KEY AUTO_INCREMENT,pattern       VARCHAR(64) NOT NULL UNIQUE,hit_count     BIGINT      NOT NULL     DEFAULT 0,require_count BIGINT      NOT NULL     DEFAULT 0,version       BIGINT      NOT NULL     DEFAULT 0)");
                return template;
            }
            catch (Exception e) {
                throw new InternalException((Throwable)e);
            }
        };
    }

    @Override
    protected Stream<AbstractMetrics.DataDO> transferResults(List<Map<String, Object>> mapResults) {
        return mapResults.stream().map(result -> {
            AbstractMetrics.DataDO dataDO = new AbstractMetrics.DataDO();
            dataDO.setRequireCount((Long)result.get("require_count"));
            dataDO.setHitCount((Long)result.get("hit_count"));
            dataDO.setPattern((String)result.get("pattern"));
            dataDO.setVersion((Long)result.get("version"));
            return dataDO;
        });
    }
}

