/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.annotation.resolve.elements;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.miaixz.bus.core.annotation.resolve.AnnotationMapping;
import org.miaixz.bus.core.annotation.resolve.RepeatableAnnotationCollector;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.AnnoKit;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CollKit;

public class RepeatableMetaAnnotatedElement<T extends AnnotationMapping<Annotation>>
implements AnnotatedElement,
Iterable<T> {
    private final AnnotatedElement element;
    private final BiFunction<T, Annotation, T> mappingFactory;
    private final List<Aggregation> aggregations;
    private final RepeatableAnnotationCollector repeatableCollector;

    RepeatableMetaAnnotatedElement(RepeatableAnnotationCollector repeatableCollector, AnnotatedElement element, BiFunction<T, Annotation, T> mappingFactory) {
        this.element = Objects.requireNonNull(element);
        this.mappingFactory = Objects.requireNonNull(mappingFactory);
        this.repeatableCollector = repeatableCollector;
        this.aggregations = Collections.unmodifiableList(this.initAggregations(element));
    }

    public static <A extends AnnotationMapping<Annotation>> RepeatableMetaAnnotatedElement<A> create(AnnotatedElement element, BiFunction<A, Annotation, A> mappingFactory) {
        return RepeatableMetaAnnotatedElement.create(RepeatableAnnotationCollector.standard(), element, mappingFactory);
    }

    public static <A extends AnnotationMapping<Annotation>> RepeatableMetaAnnotatedElement<A> create(RepeatableAnnotationCollector collector, AnnotatedElement element, BiFunction<A, Annotation, A> mappingFactory) {
        return new RepeatableMetaAnnotatedElement<A>(collector, element, mappingFactory);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.aggregations.stream().anyMatch(aggregation -> aggregation.getMappings().containsKey(annotationType));
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)((Annotation)this.aggregations.stream().map(Aggregation::getMappings).map(annotations -> (AnnotationMapping)annotations.get(annotationType)).filter(Objects::nonNull).findFirst().map(AnnotationMapping::getResolvedAnnotation).map(annotationType::cast).orElse(null));
    }

    @Override
    public Annotation[] getAnnotations() {
        return (Annotation[])this.aggregations.stream().map(aggregation -> aggregation.getMappings().values()).flatMap(Collection::stream).map(AnnotationMapping::getResolvedAnnotation).toArray(Annotation[]::new);
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        return (Annotation[])this.aggregations.stream().map(aggregation -> (AnnotationMapping)aggregation.getMappings().get(annotationType)).filter(Objects::nonNull).map(AnnotationMapping::getResolvedAnnotation).map(annotationType::cast).toArray(size -> (Annotation[])ArrayKit.newArray(annotationType, size));
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return (Annotation[])this.aggregations.stream().filter(Aggregation::isDirect).map(Aggregation::getRoot).map(AnnotationMapping::getResolvedAnnotation).toArray(Annotation[]::new);
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationType) {
        return (A)((Annotation)this.aggregations.stream().filter(Aggregation::isDirect).map(Aggregation::getRoot).filter(annotation -> Objects.equals(annotationType, annotation.annotationType())).findFirst().map(AnnotationMapping::getResolvedAnnotation).map(annotationType::cast).orElse(null));
    }

    public <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> annotationType) {
        return (Annotation[])this.aggregations.stream().filter(Aggregation::isDirect).map(Aggregation::getRoot).filter(annotation -> Objects.equals(annotationType, annotation.annotationType())).map(AnnotationMapping::getResolvedAnnotation).map(annotationType::cast).toArray(size -> (Annotation[])ArrayKit.newArray(annotationType, size));
    }

    public AnnotatedElement getElement() {
        return this.element;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepeatableMetaAnnotatedElement that = (RepeatableMetaAnnotatedElement)o;
        return this.element.equals(that.element) && this.mappingFactory.equals(that.mappingFactory) && this.repeatableCollector.equals(that.repeatableCollector);
    }

    public int hashCode() {
        return Objects.hash(this.element, this.mappingFactory, this.repeatableCollector);
    }

    @Override
    public Iterator<T> iterator() {
        return this.aggregations.stream().map(Aggregation::getMappings).map(Map::values).flatMap(Collection::stream).iterator();
    }

    private List<Aggregation> initAggregations(AnnotatedElement element) {
        ArrayList<Aggregation> result = new ArrayList<Aggregation>();
        for (Annotation declaredAnnotation : AnnoKit.getDeclaredAnnotations(element)) {
            List<Aggregation> repeatableAnnotations = this.collectRepeatable(declaredAnnotation);
            if (!CollKit.isNotEmpty(repeatableAnnotations)) continue;
            result.addAll(repeatableAnnotations);
        }
        return result;
    }

    private List<Aggregation> collectRepeatable(Annotation annotation) {
        return this.repeatableCollector.getAllRepeatableAnnotations(annotation).stream().map(a -> new Aggregation((Annotation)a, Objects.equals(a, annotation))).collect(Collectors.toList());
    }

    class Aggregation {
        private final T root;
        private final boolean isDirect;
        private volatile Map<Class<? extends Annotation>, T> mappings;

        public Aggregation(Annotation root, boolean isDirect) {
            this.root = (AnnotationMapping)RepeatableMetaAnnotatedElement.this.mappingFactory.apply(null, root);
            this.isDirect = isDirect;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Class<? extends Annotation>, T> getMappings() {
            if (Objects.isNull(this.mappings)) {
                Aggregation aggregation = this;
                synchronized (aggregation) {
                    if (Objects.isNull(this.mappings)) {
                        this.mappings = Collections.unmodifiableMap(this.initMetaAnnotations());
                    }
                }
            }
            return this.mappings;
        }

        private Map<Class<? extends Annotation>, T> initMetaAnnotations() {
            LinkedHashMap<Class<Annotation>, AnnotationMapping> collectedMappings = new LinkedHashMap<Class<Annotation>, AnnotationMapping>();
            LinkedList<Object> deque = new LinkedList<Object>();
            deque.add(this.root);
            while (!deque.isEmpty()) {
                AnnotationMapping source = (AnnotationMapping)deque.removeFirst();
                if (!this.isNeedMapping(collectedMappings, source)) continue;
                collectedMappings.put(source.annotationType(), source);
                for (Annotation annotation : AnnoKit.getDeclaredAnnotations(source.annotationType())) {
                    AnnotationMapping mapping;
                    if (collectedMappings.containsKey(annotation.annotationType()) || !Objects.nonNull(mapping = (AnnotationMapping)RepeatableMetaAnnotatedElement.this.mappingFactory.apply(source, annotation)) || !this.isNeedMapping(collectedMappings, mapping)) continue;
                    deque.addLast(mapping);
                }
            }
            return collectedMappings;
        }

        private boolean isNeedMapping(Map<Class<? extends Annotation>, T> mappings, Annotation annotation) {
            return !CharsBacker.startWith((CharSequence)annotation.annotationType().getName(), "java.lang.") && !mappings.containsKey(annotation.annotationType());
        }

        public boolean isDirect() {
            return this.isDirect;
        }

        public T getRoot() {
            return this.root;
        }
    }
}

