/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.beans;

import java.beans.Transient;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.miaixz.bus.core.annotation.Ignore;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.EnumMap;
import org.miaixz.bus.core.lang.exception.BeanException;
import org.miaixz.bus.core.xyz.AnnoKit;
import org.miaixz.bus.core.xyz.FieldKit;
import org.miaixz.bus.core.xyz.LambdaKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.ModifierKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class PropDesc {
    final Field field;
    protected Method getter;
    protected Method setter;

    public PropDesc(Field field, Method getter, Method setter) {
        this.field = field;
        this.getter = ReflectKit.setAccessible(getter);
        this.setter = ReflectKit.setAccessible(setter);
    }

    public String getFieldName() {
        return FieldKit.getFieldName(this.field);
    }

    public String getRawFieldName() {
        return null == this.field ? null : this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public Type getFieldType() {
        if (null != this.field) {
            return TypeKit.getType(this.field);
        }
        return this.findPropType(this.getter, this.setter);
    }

    public Class<?> getFieldClass() {
        if (null != this.field) {
            return TypeKit.getClass(this.field);
        }
        return this.findPropClass(this.getter, this.setter);
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public boolean isReadable(boolean checkTransient) {
        if (null == this.getter && !ModifierKit.isPublic(this.field)) {
            return false;
        }
        if (checkTransient && this.isTransientForGet()) {
            return false;
        }
        return !this.isIgnoreGet();
    }

    public Object getValue(Object bean) {
        if (null != this.getter) {
            try {
                return LambdaKit.buildGetter(this.getter).apply(bean);
            }
            catch (Exception ignore) {
                return MethodKit.invoke(bean, this.getter, new Object[0]);
            }
        }
        if (ModifierKit.isPublic(this.field)) {
            return FieldKit.getFieldValue(bean, this.field);
        }
        return null;
    }

    public Object getValue(Object bean, Type targetType, boolean ignoreError) {
        Object result;
        block3: {
            result = null;
            try {
                result = this.getValue(bean);
            }
            catch (Exception e) {
                if (ignoreError) break block3;
                throw new BeanException(e, "Get value of [{}] error!", this.getFieldName());
            }
        }
        if (null != result && null != targetType) {
            return Convert.convertWithCheck(targetType, result, null, ignoreError);
        }
        return result;
    }

    public boolean isWritable(boolean checkTransient) {
        if (null == this.setter && !ModifierKit.isPublic(this.field)) {
            return false;
        }
        if (checkTransient && this.isTransientForSet()) {
            return false;
        }
        return !this.isIgnoreSet();
    }

    public PropDesc setValue(Object bean, Object value) {
        if (null != this.setter) {
            MethodKit.invoke(bean, this.setter, value);
        } else if (ModifierKit.isPublic(this.field)) {
            FieldKit.setFieldValue(bean, this.field, value);
        }
        return this;
    }

    public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError) {
        return this.setValue(bean, value, ignoreNull, ignoreError, true);
    }

    public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError, boolean override) {
        block6: {
            Class<?> propClass;
            if (null == value && ignoreNull) {
                return this;
            }
            if (!override && null != this.getValue(bean)) {
                return this;
            }
            if (null != value && !(propClass = this.getFieldClass()).isInstance(value)) {
                value = Convert.convertWithCheck(propClass, value, null, ignoreError);
            }
            if (null != value || !ignoreNull) {
                try {
                    this.setValue(bean, value);
                }
                catch (Exception e) {
                    if (ignoreError) break block6;
                    throw new BeanException(e, "Set value of [{}] error!", this.getFieldName());
                }
            }
        }
        return this;
    }

    public String toString() {
        return "PropDesc{field=" + String.valueOf(this.field) + ", getter=" + String.valueOf(this.getter) + ", setter=" + String.valueOf(this.setter) + "}";
    }

    private Type findPropType(Method getter, Method setter) {
        Type type = null;
        if (null != getter) {
            type = TypeKit.getReturnType(getter);
        }
        if (null == type && null != setter) {
            type = TypeKit.getParamType(setter, 0);
        }
        return type;
    }

    private Class<?> findPropClass(Method getter, Method setter) {
        Class<?> type = null;
        if (null != getter) {
            type = TypeKit.getReturnClass(getter);
        }
        if (null == type && null != setter) {
            type = TypeKit.getFirstParamClass(setter);
        }
        return type;
    }

    private boolean isIgnoreSet() {
        return AnnoKit.hasAnnotation(this.field, Ignore.class) || AnnoKit.hasAnnotation(this.setter, Ignore.class);
    }

    private boolean isIgnoreGet() {
        return AnnoKit.hasAnnotation(this.field, Ignore.class) || AnnoKit.hasAnnotation(this.getter, Ignore.class);
    }

    private boolean isTransientForGet() {
        boolean isTransient = ModifierKit.hasModifier(this.field, EnumMap.Modifier.TRANSIENT);
        if (!isTransient && null != this.getter && !(isTransient = ModifierKit.hasModifier(this.getter, EnumMap.Modifier.TRANSIENT))) {
            isTransient = AnnoKit.hasAnnotation(this.getter, Transient.class);
        }
        return isTransient;
    }

    private boolean isTransientForSet() {
        boolean isTransient = ModifierKit.hasModifier(this.field, EnumMap.Modifier.TRANSIENT);
        if (!isTransient && null != this.setter && !(isTransient = ModifierKit.hasModifier(this.setter, EnumMap.Modifier.TRANSIENT))) {
            isTransient = AnnoKit.hasAnnotation(this.setter, Transient.class);
        }
        return isTransient;
    }
}

