/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.beans.copier;

import java.lang.reflect.Type;
import java.util.Map;
import org.miaixz.bus.core.beans.copier.AbstractCopier;
import org.miaixz.bus.core.beans.copier.CopyOptions;
import org.miaixz.bus.core.lang.mutable.MutableEntry;
import org.miaixz.bus.core.xyz.TypeKit;

public class MapToMapCopier
extends AbstractCopier<Map, Map> {
    private final Type targetType;

    public MapToMapCopier(Map source, Map target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public Map copy() {
        ((Map)this.source).forEach((sKey, sValue) -> {
            if (null == sKey) {
                return;
            }
            MutableEntry<String, Object> entry = this.copyOptions.editField(sKey.toString(), sValue);
            if (null == entry) {
                return;
            }
            sKey = entry.getKey();
            if (null == sKey) {
                return;
            }
            sValue = entry.getValue();
            if (this.copyOptions.ignoreNullValue && sValue == null) {
                return;
            }
            Object targetValue = ((Map)this.target).get(sKey);
            if (!this.copyOptions.override && null != targetValue) {
                return;
            }
            Type[] typeArguments = TypeKit.getTypeArguments(this.targetType);
            if (null != typeArguments) {
                sValue = this.copyOptions.convertField(typeArguments[1], sValue);
            }
            ((Map)this.target).put(sKey, sValue);
        });
        return (Map)this.target;
    }
}

