/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.cache.file;

import java.io.File;
import org.miaixz.bus.core.cache.Cache;
import org.miaixz.bus.core.cache.file.AbstractFileCache;
import org.miaixz.bus.core.cache.provider.LRUCache;

public class LRUFileCache
extends AbstractFileCache {
    private static final long serialVersionUID = -1L;

    public LRUFileCache(int capacity) {
        this(capacity, capacity / 2, 0L);
    }

    public LRUFileCache(int capacity, int maxFileSize) {
        this(capacity, maxFileSize, 0L);
    }

    public LRUFileCache(int capacity, int maxFileSize, long timeout) {
        super(capacity, maxFileSize, timeout);
    }

    @Override
    protected Cache<File, byte[]> initCache() {
        return new LRUCache<File, byte[]>(this.capacity, this.timeout){
            private static final long serialVersionUID = -1L;

            @Override
            public boolean isFull() {
                return LRUFileCache.this.usedSize > this.capacity;
            }

            @Override
            protected void onRemove(File key, byte[] cachedObject) {
                LRUFileCache.this.usedSize -= cachedObject.length;
            }
        };
    }
}

