/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.cache.provider;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.miaixz.bus.core.cache.Cache;
import org.miaixz.bus.core.cache.CacheListener;
import org.miaixz.bus.core.cache.provider.CacheObject;
import org.miaixz.bus.core.cache.provider.CacheObjectIterator;
import org.miaixz.bus.core.cache.provider.CacheValuesIterator;
import org.miaixz.bus.core.center.function.SupplierX;
import org.miaixz.bus.core.center.map.concurrent.SafeConcurrentHashMap;
import org.miaixz.bus.core.lang.mutable.Mutable;
import org.miaixz.bus.core.lang.mutable.MutableObject;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    private static final long serialVersionUID = -1L;
    protected final Map<K, Lock> keyLockMap = new SafeConcurrentHashMap<K, Lock>();
    protected Map<Mutable<K>, CacheObject<K, V>> cacheMap;
    protected int capacity;
    protected long timeout;
    protected boolean existCustomTimeout;
    protected LongAdder hitCount = new LongAdder();
    protected LongAdder missCount = new LongAdder();
    protected CacheListener<K, V> listener;

    @Override
    public void put(K key, V object) {
        this.put(key, object, this.timeout);
    }

    protected void putWithoutLock(K key, V object, long timeout) {
        CacheObject<K, V> co = new CacheObject<K, V>(key, object, timeout);
        if (timeout != 0L) {
            this.existCustomTimeout = true;
        }
        if (this.isFull()) {
            this.pruneCache();
        }
        this.cacheMap.put(MutableObject.of(key), co);
    }

    public long getHitCount() {
        return this.hitCount.sum();
    }

    public long getMissCount() {
        return this.missCount.sum();
    }

    @Override
    public V get(K key, boolean isUpdateLastAccess, SupplierX<V> supplier) {
        return this.get(key, isUpdateLastAccess, this.timeout, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, boolean isUpdateLastAccess, long timeout, SupplierX<V> supplier) {
        Object v = this.get(key, isUpdateLastAccess);
        if (null == v && null != supplier) {
            Lock keyLock = this.keyLockMap.computeIfAbsent(key, k -> new ReentrantLock());
            keyLock.lock();
            try {
                CacheObject<K, V> co = this.getWithoutLock(key);
                if (null == co || co.isExpired()) {
                    v = supplier.get();
                    this.put(key, v, timeout);
                } else {
                    v = co.get(isUpdateLastAccess);
                }
            }
            finally {
                keyLock.unlock();
                this.keyLockMap.remove(key);
            }
        }
        return v;
    }

    protected CacheObject<K, V> getWithoutLock(K key) {
        return this.cacheMap.get(MutableObject.of(key));
    }

    @Override
    public Iterator<V> iterator() {
        CacheObjectIterator copiedIterator = (CacheObjectIterator)this.cacheObjIterator();
        return new CacheValuesIterator(copiedIterator);
    }

    protected abstract int pruneCache();

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    protected boolean isPruneExpiredActive() {
        return this.timeout != 0L || this.existCustomTimeout;
    }

    @Override
    public boolean isFull() {
        return this.capacity > 0 && this.cacheMap.size() >= this.capacity;
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cacheMap.isEmpty();
    }

    public String toString() {
        return this.cacheMap.toString();
    }

    @Override
    public AbstractCache<K, V> setListener(CacheListener<K, V> listener) {
        this.listener = listener;
        return this;
    }

    public Set<K> keySet() {
        return this.cacheMap.keySet().stream().map(Mutable::get).collect(Collectors.toSet());
    }

    protected void onRemove(K key, V cachedObject) {
        CacheListener<K, V> listener = this.listener;
        if (null != listener) {
            listener.onRemove(key, cachedObject);
        }
    }

    protected CacheObject<K, V> removeWithoutLock(K key) {
        return this.cacheMap.remove(MutableObject.of(key));
    }

    protected Iterator<CacheObject<K, V>> cacheObjIter() {
        return this.cacheMap.values().iterator();
    }
}

