/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.time.temporal.WeekFields;
import org.miaixz.bus.core.center.date.Resolver;
import org.miaixz.bus.core.lang.Fields;

public class Almanac
extends Resolver {
    public static boolean isIn(TemporalAccessor date, TemporalAccessor beginDate, TemporalAccessor endDate) {
        return Almanac.isIn(date, beginDate, endDate, true, true);
    }

    public static boolean isIn(TemporalAccessor date, TemporalAccessor beginDate, TemporalAccessor endDate, boolean includeBegin, boolean includeEnd) {
        boolean isIn;
        if (date == null || beginDate == null || endDate == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u53ef\u4e3anull");
        }
        long thisMills = Almanac.toEpochMilli(date);
        long beginMills = Almanac.toEpochMilli(beginDate);
        long endMills = Almanac.toEpochMilli(endDate);
        long rangeMin = Math.min(beginMills, endMills);
        long rangeMax = Math.max(beginMills, endMills);
        boolean bl = isIn = rangeMin < thisMills && thisMills < rangeMax;
        if (!isIn && includeBegin) {
            boolean bl2 = isIn = thisMills == rangeMin;
        }
        if (!isIn && includeEnd) {
            isIn = thisMills == rangeMax;
        }
        return isIn;
    }

    public static LocalDateTime offset(LocalDateTime time, long number, TemporalUnit field) {
        return Almanac.offset(time, number, field);
    }

    public static Duration between(LocalDateTime startTimeInclude, LocalDateTime endTimeExclude) {
        return Almanac.between(startTimeInclude, endTimeExclude);
    }

    public static long between(LocalDateTime startTimeInclude, LocalDateTime endTimeExclude, ChronoUnit unit) {
        return Almanac.between(startTimeInclude, endTimeExclude, unit);
    }

    public static Period betweenPeriod(LocalDate startTimeInclude, LocalDate endTimeExclude) {
        return Period.between(startTimeInclude, endTimeExclude);
    }

    public static LocalDateTime beginOfDay(LocalDateTime time) {
        return time.with(LocalTime.MIN);
    }

    public static LocalDateTime endOfDay(LocalDateTime time, boolean truncateMillisecond) {
        return time.with(Almanac.max(truncateMillisecond));
    }

    public static LocalDateTime beginOfMonth(LocalDateTime time) {
        return Almanac.beginOfDay(time).with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDateTime endOfMonth(LocalDateTime time, boolean truncateMillisecond) {
        return Almanac.endOfDay(time, truncateMillisecond).with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDateTime beginOfYear(LocalDateTime time) {
        return Almanac.beginOfDay(time).with(TemporalAdjusters.firstDayOfYear());
    }

    public static LocalDateTime endOfYear(LocalDateTime time, boolean truncateMillisecond) {
        return Almanac.endOfDay(time, truncateMillisecond).with(TemporalAdjusters.lastDayOfYear());
    }

    public static boolean isWeekend(LocalDateTime localDateTime) {
        return Almanac.isWeekend(localDateTime.toLocalDate());
    }

    public static boolean isWeekend(LocalDate localDate) {
        DayOfWeek dayOfWeek = localDate.getDayOfWeek();
        return DayOfWeek.SATURDAY == dayOfWeek || DayOfWeek.SUNDAY == dayOfWeek;
    }

    public static Fields.Week dayOfWeek(LocalDate localDate) {
        return Fields.Week.of(localDate.getDayOfWeek());
    }

    public static boolean isOverlap(ChronoLocalDateTime<?> realStartTime, ChronoLocalDateTime<?> realEndTime, ChronoLocalDateTime<?> startTime, ChronoLocalDateTime<?> endTime) {
        return realStartTime.compareTo(endTime) <= 0 && startTime.compareTo(realEndTime) <= 0;
    }

    public static int weekOfYear(TemporalAccessor date) {
        return Almanac.get(date, WeekFields.ISO.weekOfYear());
    }

    public static boolean isSameDay(ChronoLocalDateTime<?> date1, ChronoLocalDateTime<?> date2) {
        return date1 != null && date2 != null && date1.toLocalDate().isEqual((ChronoLocalDate)date2.toLocalDate());
    }

    public static boolean isSameDay(ChronoLocalDate date1, ChronoLocalDate date2) {
        return date1 != null && date2 != null && date1.isEqual(date2);
    }

    public static <T extends Temporal> T offset(T time, long number, TemporalUnit field) {
        if (null == time) {
            return null;
        }
        return (T)time.plus(number, field);
    }

    public static Duration between(Temporal startTimeInclude, Temporal endTimeExclude) {
        return Duration.between(startTimeInclude, endTimeExclude);
    }

    public static long between(Temporal startTimeInclude, Temporal endTimeExclude, ChronoUnit unit) {
        return unit.between(startTimeInclude, endTimeExclude);
    }

    public <T extends Temporal> T offset(T temporal, DayOfWeek dayOfWeek, boolean isPrevious) {
        return (T)temporal.with(isPrevious ? TemporalAdjusters.previous(dayOfWeek) : TemporalAdjusters.next(dayOfWeek));
    }
}

