/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.miaixz.bus.core.center.date.Calendars;
import org.miaixz.bus.core.center.date.format.FormatPeriod;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Fields;
import org.miaixz.bus.core.xyz.DateKit;

public class Between
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final Date begin;
    private final Date end;

    public Between(Date begin, Date end) {
        this(begin, end, true);
    }

    public Between(Date begin, Date end, boolean isAbs) {
        Assert.notNull(begin, "Begin date is null !", new Object[0]);
        Assert.notNull(end, "End date is null !", new Object[0]);
        if (isAbs && begin.after(end)) {
            this.begin = end;
            this.end = begin;
        } else {
            this.begin = begin;
            this.end = end;
        }
    }

    public static Between of(Date begin, Date end) {
        return new Between(begin, end);
    }

    public static Between of(Date begin, Date end, boolean isAbs) {
        return new Between(begin, end, isAbs);
    }

    public long between(Fields.Units unit) {
        long diff = this.end.getTime() - this.begin.getTime();
        return diff / unit.getMillis();
    }

    public long betweenMonth(boolean isReset) {
        Calendar beginCal = DateKit.calendar(this.begin);
        Calendar endCal = DateKit.calendar(this.end);
        int betweenYear = endCal.get(1) - beginCal.get(1);
        int betweenMonthOfYear = endCal.get(2) - beginCal.get(2);
        int result = betweenYear * 12 + betweenMonthOfYear;
        if (!isReset) {
            endCal.set(1, beginCal.get(1));
            endCal.set(2, beginCal.get(2));
            long between = endCal.getTimeInMillis() - beginCal.getTimeInMillis();
            if (between < 0L) {
                return result - 1;
            }
        }
        return result;
    }

    public long betweenYear(boolean isReset) {
        Calendar beginCal = DateKit.calendar(this.begin);
        Calendar endCal = DateKit.calendar(this.end);
        int result = endCal.get(1) - beginCal.get(1);
        if (!isReset) {
            int endMonthBase0;
            int beginMonthBase0 = beginCal.get(2);
            if (beginMonthBase0 < (endMonthBase0 = endCal.get(2))) {
                return result;
            }
            if (beginMonthBase0 > endMonthBase0) {
                return result - 1;
            }
            if (1 == beginMonthBase0 && Calendars.isLastDayOfMonth(beginCal) && Calendars.isLastDayOfMonth(endCal)) {
                beginCal.set(5, 1);
                endCal.set(5, 1);
            }
            endCal.set(1, beginCal.get(1));
            long between = endCal.getTimeInMillis() - beginCal.getTimeInMillis();
            if (between < 0L) {
                return result - 1;
            }
        }
        return result;
    }

    public Date getBegin() {
        return this.begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public String toString(Fields.Units unit, FormatPeriod.Level level) {
        return DateKit.formatBetween(this.between(unit), level);
    }

    public String toString(FormatPeriod.Level level) {
        return this.toString(Fields.Units.MS, level);
    }

    public String toString() {
        return this.toString(FormatPeriod.Level.MILLISECOND);
    }
}

