/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date;

import java.text.ParsePosition;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.miaixz.bus.core.center.date.Almanac;
import org.miaixz.bus.core.center.date.DateTime;
import org.miaixz.bus.core.center.date.Modifier;
import org.miaixz.bus.core.center.date.format.CustomFormat;
import org.miaixz.bus.core.center.date.format.parser.FastDateParser;
import org.miaixz.bus.core.center.date.format.parser.PositionDateParser;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Fields;
import org.miaixz.bus.core.lang.exception.DateException;
import org.miaixz.bus.core.math.ChineseNumberFormatter;
import org.miaixz.bus.core.xyz.CompareKit;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class Calendars
extends Almanac {
    public static Calendar calendar() {
        return Calendar.getInstance();
    }

    public static Calendar calendar(Date date) {
        if (date instanceof DateTime) {
            return ((DateTime)date).toCalendar();
        }
        return Calendars.calendar(date.getTime());
    }

    public static Calendar calendar(XMLGregorianCalendar calendar) {
        return calendar.toGregorianCalendar();
    }

    public static Calendar calendar(long millis) {
        return Calendars.calendar(millis, TimeZone.getDefault());
    }

    public static Calendar calendar(long millis, TimeZone timeZone) {
        Calendar cal = Calendar.getInstance(timeZone);
        cal.setTimeInMillis(millis);
        return cal;
    }

    public static Calendar calendar(Calendar calendar, TimeZone timeZone) {
        calendar = (Calendar)calendar.clone();
        calendar.setTimeZone(timeZone);
        return calendar;
    }

    public static boolean isAM(Calendar calendar) {
        return 0 == calendar.get(9);
    }

    public static boolean isPM(Calendar calendar) {
        return 1 == calendar.get(9);
    }

    public static Calendar truncate(Calendar calendar, Fields.Type type) {
        return Modifier.modify(calendar, type.getValue(), Fields.Modify.TRUNCATE);
    }

    public static Calendar round(Calendar calendar, Fields.Type type) {
        return Modifier.modify(calendar, type.getValue(), Fields.Modify.ROUND);
    }

    public static Calendar ceiling(Calendar calendar, Fields.Type type) {
        return Modifier.modify(calendar, type.getValue(), Fields.Modify.CEILING);
    }

    public static Calendar ceiling(Calendar calendar, Fields.Type type, boolean truncateMillisecond) {
        return Modifier.modify(calendar, type.getValue(), Fields.Modify.CEILING, truncateMillisecond);
    }

    public static Calendar beginOfSecond(Calendar calendar) {
        return Calendars.truncate(calendar, Fields.Type.SECOND);
    }

    public static Calendar endOfSecond(Calendar calendar) {
        return Calendars.ceiling(calendar, Fields.Type.SECOND);
    }

    public static Calendar beginOfHour(Calendar calendar) {
        return Calendars.truncate(calendar, Fields.Type.HOUR_OF_DAY);
    }

    public static Calendar endOfHour(Calendar calendar) {
        return Calendars.ceiling(calendar, Fields.Type.HOUR_OF_DAY);
    }

    public static Calendar beginOfMinute(Calendar calendar) {
        return Calendars.truncate(calendar, Fields.Type.MINUTE);
    }

    public static Calendar endOfMinute(Calendar calendar) {
        return Calendars.ceiling(calendar, Fields.Type.MINUTE);
    }

    public static Calendar beginOfDay(Calendar calendar) {
        return Calendars.truncate(calendar, Fields.Type.DAY_OF_MONTH);
    }

    public static Calendar endOfDay(Calendar calendar) {
        return Calendars.ceiling(calendar, Fields.Type.DAY_OF_MONTH);
    }

    public static Calendar beginOfWeek(Calendar calendar) {
        return Calendars.beginOfWeek(calendar, true);
    }

    public static Calendar beginOfWeek(Calendar calendar, boolean isMondayAsFirstDay) {
        calendar.setFirstDayOfWeek(isMondayAsFirstDay ? 2 : 1);
        return Calendars.truncate(calendar, Fields.Type.WEEK_OF_MONTH);
    }

    public static Calendar endOfWeek(Calendar calendar) {
        return Calendars.endOfWeek(calendar, true);
    }

    public static Calendar endOfWeek(Calendar calendar, boolean isSundayAsLastDay) {
        calendar.setFirstDayOfWeek(isSundayAsLastDay ? 2 : 1);
        return Calendars.ceiling(calendar, Fields.Type.WEEK_OF_MONTH);
    }

    public static Calendar beginOfMonth(Calendar calendar) {
        return Calendars.truncate(calendar, Fields.Type.MONTH);
    }

    public static Calendar endOfMonth(Calendar calendar) {
        return Calendars.ceiling(calendar, Fields.Type.MONTH);
    }

    public static Calendar beginOfQuarter(Calendar calendar) {
        calendar.set(2, calendar.get(Fields.Type.MONTH.getValue()) / 3 * 3);
        calendar.set(5, 1);
        return Calendars.beginOfDay(calendar);
    }

    public static Calendar endOfQuarter(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(Fields.Type.MONTH.getValue()) / 3 * 3 + 2;
        Calendar resultCal = Calendar.getInstance(calendar.getTimeZone());
        resultCal.set(year, month, Fields.Month.of(month).getLastDay(DateKit.isLeapYear(year)));
        return Calendars.endOfDay(resultCal);
    }

    public static Calendar beginOfYear(Calendar calendar) {
        return Calendars.truncate(calendar, Fields.Type.YEAR);
    }

    public static Calendar endOfYear(Calendar calendar) {
        return Calendars.ceiling(calendar, Fields.Type.YEAR);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (ObjectKit.notEquals(cal1.getTimeZone(), cal2.getTimeZone())) {
            cal2 = Calendars.calendar(cal2, cal1.getTimeZone());
        }
        return Calendars.isSameYear(cal1, cal2) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameWeek(Calendar cal1, Calendar cal2, boolean isMon) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        cal2 = ObjectKit.notEquals((cal1 = (Calendar)cal1.clone()).getTimeZone(), cal2.getTimeZone()) ? Calendars.calendar(cal2, cal1.getTimeZone()) : (Calendar)cal2.clone();
        if (isMon) {
            cal1.setFirstDayOfWeek(2);
            cal1.set(7, 2);
            cal2.setFirstDayOfWeek(2);
            cal2.set(7, 2);
        } else {
            cal1.setFirstDayOfWeek(1);
            cal1.set(7, 1);
            cal2.setFirstDayOfWeek(1);
            cal2.set(7, 1);
        }
        return Calendars.isSameDay(cal1, cal2);
    }

    public static boolean isSameMonth(Calendar cal1, Calendar cal2) {
        if (ObjectKit.notEquals(cal1.getTimeZone(), cal2.getTimeZone())) {
            cal2 = Calendars.calendar(cal2, cal1.getTimeZone());
        }
        return Calendars.isSameYear(cal1, cal2) && cal1.get(2) == cal2.get(2);
    }

    public static boolean isSameYear(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (ObjectKit.notEquals(cal1.getTimeZone(), cal2.getTimeZone())) {
            cal2 = Calendars.calendar(cal2, cal1.getTimeZone());
        }
        return cal1.get(1) == cal2.get(1) && cal1.get(0) == cal2.get(0);
    }

    public static boolean isSameInstant(Calendar date1, Calendar date2) {
        if (null == date1) {
            return null == date2;
        }
        if (null == date2) {
            return false;
        }
        return date1.getTimeInMillis() == date2.getTimeInMillis();
    }

    public static String yearAndQuarter(Calendar cal) {
        return StringKit.builder().append(cal.get(1)).append(cal.get(2) / 3 + 1).toString();
    }

    public static int getBeginValue(Calendar calendar, Fields.Type type) {
        return Calendars.getBeginValue(calendar, type.getValue());
    }

    public static int getBeginValue(Calendar calendar, int dateField) {
        if (7 == dateField) {
            return calendar.getFirstDayOfWeek();
        }
        return calendar.getActualMinimum(dateField);
    }

    public static int getEndValue(Calendar calendar, Fields.Type type) {
        return Calendars.getEndValue(calendar, type.getValue());
    }

    public static int getEndValue(Calendar calendar, int dateField) {
        if (7 == dateField) {
            return (calendar.getFirstDayOfWeek() + 6) % 7;
        }
        return calendar.getActualMaximum(dateField);
    }

    public static int getField(Calendar calendar, Fields.Type field) {
        return Assert.notNull(calendar).get(Assert.notNull(field).getValue());
    }

    public static Instant toInstant(Calendar calendar) {
        return null == calendar ? null : calendar.toInstant();
    }

    public static LocalDateTime toLocalDateTime(Calendar calendar) {
        if (null == calendar) {
            return null;
        }
        return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
    }

    public static int compare(Calendar calendar1, Calendar calendar2) {
        return CompareKit.compare(calendar1, calendar2);
    }

    public static int age(Calendar birthday, Calendar dateToCompare) {
        return Calendars.age(birthday.getTimeInMillis(), dateToCompare.getTimeInMillis());
    }

    public static String formatChineseDate(Calendar calendar, boolean withTime) {
        StringBuilder result = StringKit.builder();
        String year = String.valueOf(calendar.get(1));
        int length = year.length();
        for (int i = 0; i < length; ++i) {
            result.append(ChineseNumberFormatter.formatChar(year.charAt(i), false));
        }
        result.append('\u5e74');
        int month = calendar.get(2) + 1;
        result.append(ChineseNumberFormatter.of().setColloquialMode(true).format(month));
        result.append('\u6708');
        int day = calendar.get(5);
        result.append(ChineseNumberFormatter.of().setColloquialMode(true).format(day));
        result.append('\u65e5');
        String temp = result.toString().replace('\u96f6', '\u3007');
        result.delete(0, result.length());
        result.append(temp);
        if (withTime) {
            int hour = calendar.get(11);
            result.append(ChineseNumberFormatter.of().setColloquialMode(true).format(hour));
            result.append('\u65f6');
            int minute = calendar.get(12);
            result.append(ChineseNumberFormatter.of().setColloquialMode(true).format(minute));
            result.append('\u5206');
            int second = calendar.get(13);
            result.append(ChineseNumberFormatter.of().setColloquialMode(true).format(second));
            result.append('\u79d2');
        }
        return result.toString();
    }

    public static Calendar parseByPatterns(String text, String ... parsePatterns) throws DateException {
        return Calendars.parseByPatterns(text, null, parsePatterns);
    }

    public static Calendar parseByPatterns(String text, Locale locale, String ... parsePatterns) throws DateException {
        return Calendars.parseByPatterns(text, locale, true, parsePatterns);
    }

    public static Calendar parseByPatterns(String text, Locale locale, boolean lenient, String ... parsePatterns) throws DateException {
        if (text == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        TimeZone tz = TimeZone.getDefault();
        Locale lcl = ObjectKit.defaultIfNull(locale, Locale.getDefault());
        ParsePosition pos = new ParsePosition(0);
        Calendar calendar = Calendar.getInstance(tz, lcl);
        calendar.setLenient(lenient);
        for (String parsePattern : parsePatterns) {
            if (CustomFormat.isCustomFormat(parsePattern)) {
                Date parse = CustomFormat.parse(text, parsePattern);
                if (null == parse) continue;
                calendar.setTime(parse);
                return calendar;
            }
            FastDateParser fdp = new FastDateParser(parsePattern, tz, lcl);
            calendar.clear();
            try {
                if (fdp.parse(text, pos, calendar) && pos.getIndex() == text.length()) {
                    return calendar;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            pos.setIndex(0);
        }
        throw new DateException("Unable to parse the date: {}", new Object[]{text});
    }

    public static Calendar parse(CharSequence text, boolean lenient, PositionDateParser parser) {
        Calendar calendar = Calendar.getInstance(parser.getTimeZone(), parser.getLocale());
        calendar.clear();
        calendar.setLenient(lenient);
        return parser.parse(StringKit.toString(text), new ParsePosition(0), calendar) ? calendar : null;
    }

    protected static int age(long birthday, long dateToCompare) {
        if (birthday > dateToCompare) {
            throw new IllegalArgumentException("Birthday is after dateToCompare!");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(dateToCompare);
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        cal.setTimeInMillis(birthday);
        int age = year - cal.get(1);
        if (age == 0) {
            return 0;
        }
        int monthBirth = cal.get(2);
        if (month == monthBirth) {
            int dayOfMonthBirth = cal.get(5);
            if (dayOfMonth <= dayOfMonthBirth) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }

    public static boolean isFirstDayOfMonth(Calendar calendar) {
        return 1 == calendar.get(5);
    }

    public static boolean isLastDayOfMonth(Calendar calendar) {
        return calendar.get(5) == calendar.getActualMaximum(5);
    }
}

