/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.miaixz.bus.core.center.date.Between;
import org.miaixz.bus.core.center.date.Calendars;
import org.miaixz.bus.core.center.date.Converter;
import org.miaixz.bus.core.center.date.Formatter;
import org.miaixz.bus.core.center.date.format.CustomFormat;
import org.miaixz.bus.core.center.date.format.FormatBuilder;
import org.miaixz.bus.core.center.date.format.FormatPeriod;
import org.miaixz.bus.core.center.date.format.parser.PositionDateParser;
import org.miaixz.bus.core.center.date.printer.FormatPrinter;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Fields;
import org.miaixz.bus.core.lang.Keys;
import org.miaixz.bus.core.lang.exception.DateException;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.ZoneKit;

public class DateTime
extends Date {
    private static final long serialVersionUID = -1L;
    private static boolean useJdkToStringStyle = false;
    private boolean mutable = true;
    private Fields.Week firstDayOfWeek = Fields.Week.MONDAY;
    private TimeZone timeZone;
    private int minimalDaysInFirstWeek;

    public DateTime() {
        this(TimeZone.getDefault());
    }

    public DateTime(TimeZone timeZone) {
        this(System.currentTimeMillis(), timeZone);
    }

    public DateTime(Date date) {
        this(date, date instanceof DateTime ? ((DateTime)date).timeZone : TimeZone.getDefault());
    }

    public DateTime(Date date, TimeZone timeZone) {
        this(ObjectKit.defaultIfNull(date, Date::new).getTime(), timeZone);
    }

    public DateTime(Calendar calendar) {
        this(calendar.getTime(), calendar.getTimeZone());
        this.setFirstDayOfWeek(Fields.Week.of(calendar.getFirstDayOfWeek()));
    }

    public DateTime(Instant instant) {
        this(instant.toEpochMilli());
    }

    public DateTime(Instant instant, ZoneId zoneId) {
        this(instant.toEpochMilli(), ZoneKit.toTimeZone(zoneId));
    }

    public DateTime(TemporalAccessor temporalAccessor) {
        this(Converter.toInstant(temporalAccessor));
    }

    public DateTime(ZonedDateTime zonedDateTime) {
        this(zonedDateTime.toInstant(), zonedDateTime.getZone());
    }

    public DateTime(long timeMillis) {
        this(timeMillis, TimeZone.getDefault());
    }

    public DateTime(long timeMillis, TimeZone timeZone) {
        super(timeMillis);
        this.timeZone = ObjectKit.defaultIfNull(timeZone, TimeZone::getDefault);
    }

    public DateTime(CharSequence dateStr) {
        this(DateKit.parse(dateStr));
    }

    public DateTime(CharSequence dateStr, String format) {
        this(CustomFormat.isCustomFormat(format) ? CustomFormat.parse(dateStr, format) : DateTime.parse(dateStr, DateKit.newSimpleFormat(format)));
    }

    public DateTime(CharSequence dateStr, DateFormat dateFormat) {
        this(DateTime.parse(dateStr, dateFormat), dateFormat.getTimeZone());
    }

    public DateTime(CharSequence dateStr, DateTimeFormatter formatter) {
        this(Converter.toInstant(formatter.parse(dateStr)), formatter.getZone());
    }

    public DateTime(CharSequence dateStr, PositionDateParser dateParser) {
        this(dateStr, dateParser, Keys.getBoolean("bus.date.lenient", true));
    }

    public DateTime(CharSequence dateStr, PositionDateParser dateParser, boolean lenient) {
        this(DateTime.parse(dateStr, dateParser, lenient));
    }

    public static void setUseJdkToStringStyle(boolean customUseJdkToStringStyle) {
        useJdkToStringStyle = customUseJdkToStringStyle;
    }

    public static DateTime of(long timeMillis) {
        return new DateTime(timeMillis);
    }

    public static DateTime of(Date date) {
        if (date instanceof DateTime) {
            return (DateTime)date;
        }
        return new DateTime(date);
    }

    public static DateTime of(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static DateTime of(String dateStr, String format) {
        return new DateTime((CharSequence)dateStr, format);
    }

    public static DateTime now() {
        return new DateTime();
    }

    private static Date parse(CharSequence dateStr, DateFormat dateFormat) {
        Assert.notBlank(dateStr, "Date String must be not blank !", new Object[0]);
        try {
            return dateFormat.parse(dateStr.toString());
        }
        catch (Exception e) {
            String pattern = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : dateFormat.toString();
            throw new DateException(StringKit.format("Parse [{}] with format [{}] error!", dateStr, pattern), e);
        }
    }

    private static Calendar parse(CharSequence dateStr, PositionDateParser parser, boolean lenient) {
        Assert.notNull(parser, "Parser or DateFromat must be not null !", new Object[0]);
        Assert.notBlank(dateStr, "Date String must be not blank !", new Object[0]);
        Calendar calendar = Calendars.parse(dateStr, lenient, parser);
        if (null == calendar) {
            throw new DateException("Parse [{}] with format [{}] error!", dateStr, parser.getPattern());
        }
        calendar.setFirstDayOfWeek(Fields.Week.MONDAY.getValue());
        return calendar;
    }

    public DateTime offset(Fields.Type datePart, int offset) {
        if (Fields.Type.ERA == datePart) {
            throw new IllegalArgumentException("ERA is not support offset!");
        }
        Calendar cal = this.toCalendar();
        cal.add(datePart.getValue(), offset);
        DateTime dt = this.mutable ? this : ObjectKit.clone(this);
        return dt.setTimeInternal(cal.getTimeInMillis());
    }

    public DateTime offsetNew(Fields.Type datePart, int offset) {
        Calendar cal = this.toCalendar();
        cal.add(datePart.getValue(), offset);
        return ObjectKit.clone(this).setTimeInternal(cal.getTimeInMillis());
    }

    public int getField(Fields.Type field) {
        return this.getField(field.getValue());
    }

    public int getField(int field) {
        return this.toCalendar().get(field);
    }

    public DateTime setField(Fields.Type field, int value) {
        return this.setField(field.getValue(), value);
    }

    public DateTime setField(int field, int value) {
        Calendar calendar = this.toCalendar();
        calendar.set(field, value);
        DateTime dt = this;
        if (!this.mutable) {
            dt = ObjectKit.clone(this);
        }
        return dt.setTimeInternal(calendar.getTimeInMillis());
    }

    @Override
    public void setTime(long time) {
        if (!this.mutable) {
            throw new DateException("This is not a mutable object !");
        }
        super.setTime(time);
    }

    public int year() {
        return this.getField(Fields.Type.YEAR);
    }

    public int quarter() {
        return this.month() / 3 + 1;
    }

    public Fields.Quarter quarterEnum() {
        return Fields.Quarter.of(this.quarter());
    }

    public int month() {
        return this.getField(Fields.Type.MONTH);
    }

    public int monthBaseOne() {
        return this.month() + 1;
    }

    public int monthStartFromOne() {
        return this.month() + 1;
    }

    public Fields.Month monthEnum() {
        return Fields.Month.of(this.month());
    }

    public int weekOfYear() {
        return this.getField(Fields.Type.WEEK_OF_YEAR);
    }

    public int weekOfMonth() {
        return this.getField(Fields.Type.WEEK_OF_MONTH);
    }

    public int dayOfMonth() {
        return this.getField(Fields.Type.DAY_OF_MONTH);
    }

    public int dayOfYear() {
        return this.getField(Fields.Type.DAY_OF_YEAR);
    }

    public int dayOfWeek() {
        return this.getField(Fields.Type.DAY_OF_WEEK);
    }

    public int dayOfWeekInMonth() {
        return this.getField(Fields.Type.DAY_OF_WEEK_IN_MONTH);
    }

    public Fields.Week dayOfWeekEnum() {
        return Fields.Week.of(this.dayOfWeek());
    }

    public int hour(boolean is24HourClock) {
        return this.getField(is24HourClock ? Fields.Type.HOUR_OF_DAY : Fields.Type.HOUR);
    }

    public int minute() {
        return this.getField(Fields.Type.MINUTE);
    }

    public int second() {
        return this.getField(Fields.Type.SECOND);
    }

    public int millisecond() {
        return this.getField(Fields.Type.MILLISECOND);
    }

    public boolean isAM() {
        return 0 == this.getField(Fields.Type.AM_PM);
    }

    public boolean isPM() {
        return 1 == this.getField(Fields.Type.AM_PM);
    }

    public boolean isWeekend() {
        int dayOfWeek = this.dayOfWeek();
        return 7 == dayOfWeek || 1 == dayOfWeek;
    }

    public boolean isLeapYear() {
        return DateKit.isLeapYear(this.year());
    }

    public Calendar toCalendar() {
        return this.toCalendar(Locale.getDefault(Locale.Category.FORMAT));
    }

    public Calendar toCalendar(Locale locale) {
        return this.toCalendar(this.timeZone, locale);
    }

    public Calendar toCalendar(TimeZone zone) {
        return this.toCalendar(zone, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Calendar toCalendar(TimeZone zone, Locale locale) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        Calendar cal = null != zone ? Calendar.getInstance(zone, locale) : Calendar.getInstance(locale);
        cal.setFirstDayOfWeek(this.firstDayOfWeek.getValue());
        if (this.minimalDaysInFirstWeek > 0) {
            cal.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
        }
        cal.setTime(this);
        return cal;
    }

    public Date toJdkDate() {
        return new Date(this.getTime());
    }

    public LocalDateTime toLocalDateTime() {
        return Converter.of(this);
    }

    public Between between(Date date) {
        return new Between(this, date);
    }

    public long between(Date date, Fields.Units unit) {
        return new Between(this, date).between(unit);
    }

    public String between(Date date, Fields.Units unit, FormatPeriod.Level formatLevel) {
        return new Between(this, date).toString(unit, formatLevel);
    }

    public boolean isIn(Date beginDate, Date endDate) {
        return this.isIn(this, beginDate, endDate);
    }

    public boolean isIn(Date date, Date beginDate, Date endDate) {
        return this.isIn(date, beginDate, endDate, true, true);
    }

    public boolean isIn(Date date, Date beginDate, Date endDate, boolean includeBegin, boolean includeEnd) {
        boolean isIn;
        if (date == null || beginDate == null || endDate == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u53ef\u4e3anull");
        }
        long thisMills = date.getTime();
        long beginMills = beginDate.getTime();
        long endMills = endDate.getTime();
        long rangeMin = Math.min(beginMills, endMills);
        long rangeMax = Math.max(beginMills, endMills);
        boolean bl = isIn = rangeMin < thisMills && thisMills < rangeMax;
        if (!isIn && includeBegin) {
            boolean bl2 = isIn = thisMills == rangeMin;
        }
        if (!isIn && includeEnd) {
            isIn = thisMills == rangeMax;
        }
        return isIn;
    }

    public boolean isBefore(Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) < 0;
    }

    public boolean isBeforeOrEquals(Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) <= 0;
    }

    public boolean isAfter(Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) > 0;
    }

    public boolean isAfterOrEquals(Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) >= 0;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public DateTime setMutable(boolean mutable) {
        this.mutable = mutable;
        return this;
    }

    public Fields.Week getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public DateTime setFirstDayOfWeek(Fields.Week firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        return this;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public DateTime setTimeZone(TimeZone timeZone) {
        this.timeZone = ObjectKit.defaultIfNull(timeZone, TimeZone::getDefault);
        return this;
    }

    public ZoneId getZoneId() {
        return this.timeZone.toZoneId();
    }

    public DateTime setMinimalDaysInFirstWeek(int minimalDaysInFirstWeek) {
        this.minimalDaysInFirstWeek = minimalDaysInFirstWeek;
        return this;
    }

    public boolean isLastDayOfMonth() {
        return this.dayOfMonth() == this.getLastDayOfMonth();
    }

    public int getLastDayOfMonth() {
        return this.monthEnum().getLastDay(this.isLeapYear());
    }

    @Override
    public String toString() {
        if (useJdkToStringStyle) {
            return super.toString();
        }
        return this.toString(this.timeZone);
    }

    public String toStringDefaultTimeZone() {
        return this.toString(TimeZone.getDefault());
    }

    public String toString(TimeZone timeZone) {
        if (null != timeZone) {
            return this.toString(DateKit.newSimpleFormat("yyyy-MM-dd HH:mm:ss", null, timeZone));
        }
        return this.toString(Formatter.NORM_DATETIME_FORMAT);
    }

    public String toDateString() {
        if (null != this.timeZone) {
            return this.toString(DateKit.newSimpleFormat("yyyy-MM-dd", null, this.timeZone));
        }
        return this.toString(Formatter.NORM_DATE_FORMAT);
    }

    public String toTimeString() {
        if (null != this.timeZone) {
            return this.toString(DateKit.newSimpleFormat("HH:mm:ss", null, this.timeZone));
        }
        return this.toString(Formatter.NORM_TIME_FORMAT);
    }

    public String toString(String format) {
        if (null != this.timeZone) {
            return this.toString(DateKit.newSimpleFormat(format, null, this.timeZone));
        }
        return this.toString(FormatBuilder.getInstance(format));
    }

    public String toString(FormatPrinter format) {
        return format.format(this);
    }

    public String toString(DateFormat format) {
        return format.format(this);
    }

    public String toMsString() {
        return this.toString(Formatter.NORM_DATETIME_MS_FORMAT);
    }

    private DateTime setTimeInternal(long time) {
        super.setTime(time);
        return this;
    }
}

