/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.Era;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Function;
import org.miaixz.bus.core.center.date.format.CustomFormat;
import org.miaixz.bus.core.center.date.format.FormatBuilder;
import org.miaixz.bus.core.xyz.LambdaKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.ZoneKit;

public class Formatter {
    public static final FormatBuilder NORM_MONTH_FORMAT = FormatBuilder.getInstance("yyyy-MM");
    public static final DateTimeFormatter NORM_MONTH_FORMATTER = FormatBuilder.getDateTimeInstance("yyyy-MM");
    public static final FormatBuilder SIMPLE_MONTH_FORMAT = FormatBuilder.getInstance("yyyyMM");
    public static final DateTimeFormatter SIMPLE_MONTH_FORMATTER = FormatBuilder.getDateTimeInstance("yyyyMM");
    public static final FormatBuilder NORM_DATE_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd");
    public static final DateTimeFormatter NORM_DATE_FORMATTER = FormatBuilder.getDateTimeInstance("yyyy-MM-dd");
    public static final FormatBuilder NORM_TIME_FORMAT = FormatBuilder.getInstance("HH:mm:ss");
    public static final DateTimeFormatter NORM_TIME_FORMATTER = FormatBuilder.getDateTimeInstance("HH:mm:ss");
    public static final FormatBuilder NORM_DATETIME_MINUTE_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd HH:mm");
    public static final DateTimeFormatter NORM_DATETIME_MINUTE_FORMATTER = FormatBuilder.getDateTimeInstance("yyyy-MM-dd HH:mm");
    public static final FormatBuilder NORM_DATETIME_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter NORM_DATETIME_FORMATTER = FormatBuilder.getDateTimeInstance("yyyy-MM-dd HH:mm:ss");
    public static final FormatBuilder NORM_DATETIME_MS_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd HH:mm:ss.SSS");
    public static final DateTimeFormatter NORM_DATETIME_MS_FORMATTER = FormatBuilder.getDateTimeInstance("yyyy-MM-dd HH:mm:ss.SSS");
    public static final FormatBuilder NORM_DATETIME_COMMA_MS_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd HH:mm:ss,SSS");
    public static final DateTimeFormatter NORM_DATETIME_COMMA_MS_FORMATTER = FormatBuilder.getDateTimeInstance("yyyy-MM-dd HH:mm:ss,SSS");
    public static final FormatBuilder CN_DATE_FORMAT = FormatBuilder.getInstance("yyyy\u5e74MM\u6708dd\u65e5");
    public static final DateTimeFormatter CN_DATE_FORMATTER = FormatBuilder.getDateTimeInstance("yyyy\u5e74MM\u6708dd\u65e5");
    public static final FormatBuilder CN_DATE_TIME_FORMAT = FormatBuilder.getInstance("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
    public static final DateTimeFormatter CN_DATE_TIME_FORMATTER = FormatBuilder.getDateTimeInstance("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
    public static final FormatBuilder PURE_DATE_FORMAT = FormatBuilder.getInstance("yyyyMMdd");
    public static final DateTimeFormatter PURE_DATE_FORMATTER = FormatBuilder.getDateTimeInstance("yyyyMMdd");
    public static final FormatBuilder PURE_TIME_FORMAT = FormatBuilder.getInstance("HHmmss");
    public static final DateTimeFormatter PURE_TIME_FORMATTER = FormatBuilder.getDateTimeInstance("HHmmss");
    public static final FormatBuilder PURE_DATETIME_FORMAT = FormatBuilder.getInstance("yyyyMMddHHmmss");
    public static final DateTimeFormatter PURE_DATETIME_FORMATTER = FormatBuilder.getDateTimeInstance("yyyyMMddHHmmss");
    public static final FormatBuilder PURE_DATETIME_MS_FORMAT = FormatBuilder.getInstance("yyyyMMddHHmmssSSS");
    public static final FormatBuilder PURE_DATETIME_TIP_FORMAT = FormatBuilder.getInstance("yyyyMMddHHmmss.SSS");
    public static final DateTimeFormatter PURE_DATETIME_MS_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyyMMddHHmmss").appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();
    public static final FormatBuilder HTTP_DATETIME_FORMAT_GMT = FormatBuilder.getInstance("EEE, dd MMM yyyy HH:mm:ss z", TimeZone.getTimeZone("GMT"), Locale.US);
    public static final FormatBuilder HTTP_DATETIME_FORMAT = FormatBuilder.getInstance("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    public static final FormatBuilder JDK_DATETIME_FORMAT = FormatBuilder.getInstance("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
    public static final FormatBuilder ISO8601_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd'T'HH:mm:ss");
    public static final FormatBuilder ISO8601_MS_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSS");
    public static final FormatBuilder UTC_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd'T'HH:mm:ss'Z'", ZoneKit.ZONE_UTC);
    public static final FormatBuilder ISO8601_WITH_ZONE_OFFSET_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd'T'HH:mm:ssZ");
    public static final FormatBuilder ISO8601_WITH_XXX_OFFSET_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd'T'HH:mm:ssXXX");
    public static final FormatBuilder UTC_MS_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", ZoneKit.ZONE_UTC);
    public static final FormatBuilder ISO8601_MS_WITH_ZONE_OFFSET_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static final FormatBuilder ISO8601_MS_WITH_XXX_OFFSET_FORMAT = FormatBuilder.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    public static final LocalTime MAX_HMS = LocalTime.of(23, 59, 59);

    public static String format(TemporalAccessor time, DateTimeFormatter formatter) {
        if (null == time) {
            return null;
        }
        if (time instanceof Month) {
            return time.toString();
        }
        if (null == formatter) {
            formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        }
        try {
            return formatter.format(time);
        }
        catch (UnsupportedTemporalTypeException e) {
            if (time instanceof LocalDate && e.getMessage().contains("HourOfDay")) {
                return formatter.format(((LocalDate)time).atStartOfDay());
            }
            if (time instanceof LocalTime && e.getMessage().contains("YearOfEra")) {
                return formatter.format(((LocalTime)time).atDate(LocalDate.now()));
            }
            if (time instanceof Instant) {
                return formatter.format(((Instant)time).atZone(ZoneId.systemDefault()));
            }
            throw e;
        }
    }

    public static String format(TemporalAccessor time, String format) {
        if (null == time) {
            return null;
        }
        if (time instanceof DayOfWeek || time instanceof Month || time instanceof Era || time instanceof MonthDay) {
            return time.toString();
        }
        if (CustomFormat.isCustomFormat(format)) {
            return CustomFormat.format(time, (CharSequence)format);
        }
        DateTimeFormatter formatter = StringKit.isBlank(format) ? null : DateTimeFormatter.ofPattern(format);
        return Formatter.format(time, formatter);
    }

    public static String formatNormal(ChronoLocalDateTime<?> time) {
        return Formatter.format(time, NORM_DATETIME_FORMATTER);
    }

    public static String formatNormal(ChronoLocalDate date) {
        return Formatter.format((TemporalAccessor)date, NORM_DATE_FORMATTER);
    }

    public static Function<TemporalAccessor, String> formatFunc(DateTimeFormatter dateTimeFormatter) {
        return LambdaKit.toFunction(Formatter::format, dateTimeFormatter);
    }
}

