/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.miaixz.bus.core.center.date.Converter;
import org.miaixz.bus.core.center.date.Formatter;
import org.miaixz.bus.core.center.date.format.CustomFormat;
import org.miaixz.bus.core.xyz.StringKit;

public class Resolver
extends Converter {
    public static LocalDateTime parseTime(CharSequence text, String format) {
        if (StringKit.isBlank((CharSequence)text)) {
            return null;
        }
        if (CustomFormat.isCustomFormat(format)) {
            return Resolver.of(CustomFormat.parse((CharSequence)text, format));
        }
        DateTimeFormatter formatter = null;
        if (StringKit.isNotBlank(format)) {
            if (StringKit.startWithIgnoreEquals(format, "yyyyMMddHHmmss") && format.endsWith("S")) {
                int paddingWidth = 3 - (format.length() - "yyyyMMddHHmmss".length());
                if (paddingWidth > 0) {
                    text = String.valueOf(text) + StringKit.repeat('0', paddingWidth);
                }
                formatter = Formatter.PURE_DATETIME_MS_FORMATTER;
            } else {
                formatter = DateTimeFormatter.ofPattern(format);
            }
        }
        return Resolver.parseTime((CharSequence)text, formatter);
    }

    public static LocalDateTime parseTime(CharSequence text, DateTimeFormatter formatter) {
        if (StringKit.isBlank(text)) {
            return null;
        }
        if (null == formatter) {
            return LocalDateTime.parse(text);
        }
        return Resolver.of(formatter.parse(text));
    }

    public static LocalDate parseDate(CharSequence text, String format) {
        if (StringKit.isBlank(text)) {
            return null;
        }
        return Resolver.parseDate(text, DateTimeFormatter.ofPattern(format));
    }

    public static LocalDate parseDate(CharSequence text, DateTimeFormatter formatter) {
        if (StringKit.isBlank(text)) {
            return null;
        }
        if (null == formatter) {
            return LocalDate.parse(text);
        }
        return Resolver.ofDate(formatter.parse(text));
    }

    public static LocalDate parseDateByISO(CharSequence text) {
        return Resolver.parseDate(text, (DateTimeFormatter)null);
    }

    public static LocalDateTime parseTimeByISO(CharSequence text) {
        if (StringKit.contains(text, 'T')) {
            return Resolver.parseTime(text, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        return Resolver.parseTime(text, Formatter.NORM_DATETIME_FORMATTER);
    }
}

