/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.chinese;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.core.center.date.Between;
import org.miaixz.bus.core.xyz.StringKit;

public class ShiChen {
    private static final Map<String, Integer> timeMap = new HashMap<String, Integer>();
    private static final Map<String, Integer[]> fullTimeMap = new HashMap<String, Integer[]>();
    private static final Map<Integer, String> hourToShiChenMap = new HashMap<Integer, String>();
    private static final Map<Integer, String> hourToShiChenAbsMap = new HashMap<Integer, String>();

    public static Between toModernTime(String shiChen) {
        Integer endHour;
        Integer startHour;
        if (StringKit.isEmpty(shiChen)) {
            throw new IllegalArgumentException("Invalid shiChen");
        }
        if (shiChen.endsWith("\u521d") || shiChen.endsWith("\u6b63")) {
            startHour = timeMap.get(shiChen);
            if (startHour == null) {
                throw new IllegalArgumentException("Invalid ShiChen time");
            }
            endHour = (startHour + 1) % 24;
        } else {
            String baseTime = shiChen.replace("\u65f6", "");
            Integer[] hours = fullTimeMap.get(baseTime);
            if (hours == null) {
                throw new IllegalArgumentException("Invalid ShiChen time");
            }
            startHour = hours[0];
            endHour = hours[1];
        }
        LocalDateTime start = LocalDateTime.now().withHour(startHour).withMinute(0).withSecond(0).withNano(0);
        LocalDateTime end = startHour > endHour ? start.plusDays(1L).withHour(endHour) : start.withHour(endHour);
        Date startDate = Date.from(start.atZone(ZoneId.systemDefault()).toInstant());
        Date endDate = Date.from(end.atZone(ZoneId.systemDefault()).toInstant());
        return Between.of(startDate, endDate);
    }

    public static String toShiChen(int hour, boolean isAbs) {
        String result = hourToShiChenAbsMap.getOrDefault(hour, "\u672a\u77e5");
        if (!isAbs && !result.equals("\u672a\u77e5")) {
            result = hourToShiChenMap.get(hour);
        }
        return result;
    }

    static {
        String[] times = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
        int hour = 23;
        for (String time : times) {
            timeMap.put(time + "\u521d", hour % 24);
            timeMap.put(time + "\u6b63", (hour + 1) % 24);
            fullTimeMap.put(time, new Integer[]{hour % 24, (hour + 2) % 24});
            hour += 2;
        }
        hour = 23;
        for (String time : times) {
            hourToShiChenMap.put(hour % 24, time + "\u521d");
            hourToShiChenMap.put((hour + 1) % 24, time + "\u6b63");
            hourToShiChenAbsMap.put(hour % 24, time + "\u65f6");
            hourToShiChenAbsMap.put((hour + 1) % 24, time + "\u65f6");
            hour += 2;
        }
    }
}

