/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.format.parser;

import java.util.regex.Pattern;
import org.miaixz.bus.core.center.date.DateTime;
import org.miaixz.bus.core.center.date.Formatter;
import org.miaixz.bus.core.center.date.format.parser.PredicateDateParser;
import org.miaixz.bus.core.center.date.printer.DefaultDatePrinter;
import org.miaixz.bus.core.lang.exception.DateException;
import org.miaixz.bus.core.xyz.PatternKit;
import org.miaixz.bus.core.xyz.StringKit;

public class NormalDateParser
extends DefaultDatePrinter
implements PredicateDateParser {
    private static final long serialVersionUID = -1L;
    private static final Pattern patternNorm = Pattern.compile("\\d{4}-\\d{1,2}-\\d{1,2}(\\s\\d{1,2}:\\d{1,2}(:\\d{1,2})?(.\\d{1,6})?)?");
    public static NormalDateParser INSTANCE = new NormalDateParser();

    @Override
    public boolean test(CharSequence dateStr) {
        return PatternKit.isMatch(patternNorm, dateStr);
    }

    @Override
    public DateTime parse(String source) throws DateException {
        int colonCount = StringKit.count((CharSequence)source, ':');
        switch (colonCount) {
            case 0: {
                return new DateTime((CharSequence)source, Formatter.NORM_DATE_FORMAT);
            }
            case 1: {
                return new DateTime((CharSequence)source, Formatter.NORM_DATETIME_MINUTE_FORMAT);
            }
            case 2: {
                int indexOfDot = StringKit.indexOf(source, '.');
                if (indexOfDot > 0) {
                    int length1 = source.length();
                    if (length1 - indexOfDot > 4) {
                        source = StringKit.subPre(source, indexOfDot + 4);
                    }
                    return new DateTime((CharSequence)source, Formatter.NORM_DATETIME_MS_FORMAT);
                }
                return new DateTime((CharSequence)source, Formatter.NORM_DATETIME_FORMAT);
            }
        }
        throw new DateException("No format fit for date String [{}] !", new Object[]{source});
    }
}

