/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.format.parser;

import org.miaixz.bus.core.center.date.DateTime;
import org.miaixz.bus.core.center.date.Formatter;
import org.miaixz.bus.core.center.date.format.parser.PredicateDateParser;
import org.miaixz.bus.core.center.date.printer.DefaultDatePrinter;
import org.miaixz.bus.core.lang.exception.DateException;
import org.miaixz.bus.core.xyz.MathKit;

public class PureDateParser
extends DefaultDatePrinter
implements PredicateDateParser {
    private static final long serialVersionUID = -1L;
    public static PureDateParser INSTANCE = new PureDateParser();

    @Override
    public boolean test(CharSequence dateStr) {
        return MathKit.isNumber(dateStr);
    }

    @Override
    public DateTime parse(String source) throws DateException {
        int length = source.length();
        if (length == "yyyyMMddHHmmss".length()) {
            return new DateTime((CharSequence)source, Formatter.PURE_DATETIME_FORMAT);
        }
        if (length == "yyyyMMddHHmmssSSS".length()) {
            return new DateTime((CharSequence)source, Formatter.PURE_DATETIME_MS_FORMAT);
        }
        if (length == "yyyyMMdd".length()) {
            return new DateTime((CharSequence)source, Formatter.PURE_DATE_FORMAT);
        }
        if (length == "HHmmss".length()) {
            return new DateTime((CharSequence)source, Formatter.PURE_TIME_FORMAT);
        }
        if (length >= 11 && length <= 13) {
            return new DateTime(MathKit.parseLong(source));
        }
        throw new DateException("No pure format fit for date String [{}] !", new Object[]{source});
    }
}

