/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.iterator;

import java.util.NoSuchElementException;
import org.miaixz.bus.core.center.iterator.ResettableIterator;
import org.miaixz.bus.core.lang.Assert;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListIterator
implements ResettableIterator<Node> {
    private final NodeList nodeList;
    private int index = 0;

    public NodeListIterator(NodeList nodeList) {
        this.nodeList = Assert.notNull(nodeList, "NodeList must not be null.", new Object[0]);
    }

    @Override
    public boolean hasNext() {
        return this.nodeList != null && this.index < this.nodeList.getLength();
    }

    @Override
    public Node next() {
        if (this.nodeList != null && this.index < this.nodeList.getLength()) {
            return this.nodeList.item(this.index++);
        }
        throw new NoSuchElementException("underlying nodeList has no more elements");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method not supported for a NodeListIterator.");
    }

    @Override
    public void reset() {
        this.index = 0;
    }
}

