/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.map;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.miaixz.bus.core.center.map.MapWrapper;
import org.miaixz.bus.core.xyz.MapKit;

public class BiMap<K, V>
extends MapWrapper<K, V> {
    private static final long serialVersionUID = -1L;
    private Map<V, K> inverse;

    public BiMap(Map<K, V> raw) {
        super(raw);
    }

    @Override
    public V put(K key, V value) {
        V oldValue = super.put(key, value);
        if (null != this.inverse) {
            if (null != oldValue) {
                this.inverse.remove(oldValue);
            }
            this.inverse.put(value, key);
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        super.putAll(m);
        if (null != this.inverse) {
            m.forEach((? super K key, ? super V value) -> this.inverse.put(value, key));
        }
    }

    @Override
    public V remove(Object key) {
        Object v = super.remove(key);
        if (null != this.inverse && null != v) {
            this.inverse.remove(v);
        }
        return v;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return super.remove(key, value) && null != this.inverse && this.inverse.remove(value, key);
    }

    @Override
    public void clear() {
        super.clear();
        this.inverse = null;
    }

    public Map<V, K> getInverse() {
        if (null == this.inverse) {
            this.inverse = MapKit.inverse(this.getRaw());
        }
        return this.inverse;
    }

    public K getKey(V value) {
        return this.getInverse().get(value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (null != this.inverse) {
            this.inverse.putIfAbsent(value, key);
        }
        return super.putIfAbsent(key, value);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V result = super.computeIfAbsent(key, mappingFunction);
        this.resetInverseMap();
        return result;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V result = super.computeIfPresent(key, remappingFunction);
        this.resetInverseMap();
        return result;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V result = super.compute(key, remappingFunction);
        this.resetInverseMap();
        return result;
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V result = super.merge(key, value, remappingFunction);
        this.resetInverseMap();
        return result;
    }

    private void resetInverseMap() {
        if (null != this.inverse) {
            this.inverse = null;
        }
    }
}

