/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.map;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.miaixz.bus.core.beans.copier.CopyOptions;
import org.miaixz.bus.core.beans.path.BeanPath;
import org.miaixz.bus.core.center.function.FunctionX;
import org.miaixz.bus.core.center.function.LambdaInfo;
import org.miaixz.bus.core.center.function.SupplierX;
import org.miaixz.bus.core.center.map.CustomKeyMap;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.CloneException;
import org.miaixz.bus.core.lang.getter.TypeGetter;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.LambdaKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.SetKit;

public class Dictionary
extends CustomKeyMap<String, Object>
implements TypeGetter<String> {
    private static final long serialVersionUID = -1L;
    private boolean caseInsensitive;

    public Dictionary() {
        this(false);
    }

    public Dictionary(boolean caseInsensitive) {
        this(16, caseInsensitive);
    }

    public Dictionary(int initialCapacity) {
        this(initialCapacity, false);
    }

    public Dictionary(int initialCapacity, boolean caseInsensitive) {
        this(initialCapacity, 0.75f, caseInsensitive);
    }

    public Dictionary(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, false);
    }

    public Dictionary(int initialCapacity, float loadFactor, boolean caseInsensitive) {
        super(new LinkedHashMap(initialCapacity, loadFactor));
        this.caseInsensitive = caseInsensitive;
    }

    public Dictionary(Map<String, Object> m) {
        super(null == m ? new HashMap() : m);
    }

    public static Dictionary of() {
        return new Dictionary();
    }

    public static <T> Dictionary parse(T bean) {
        return Dictionary.of().parseBean(bean);
    }

    @SafeVarargs
    public static Dictionary ofEntries(Map.Entry<String, Object> ... pairs) {
        Dictionary dictionary = Dictionary.of();
        for (Map.Entry<String, Object> pair : pairs) {
            dictionary.put(pair.getKey(), pair.getValue());
        }
        return dictionary;
    }

    public static Dictionary ofKvs(Object ... keysAndValues) {
        Dictionary dictionary = Dictionary.of();
        String key = null;
        for (int i = 0; i < keysAndValues.length; ++i) {
            if ((i & 1) == 0) {
                key = Convert.toString(keysAndValues[i]);
                continue;
            }
            dictionary.put(key, keysAndValues[i]);
        }
        return dictionary;
    }

    public <T> T toBean(T bean) {
        return BeanKit.fillBeanWithMap(this, bean, CopyOptions.of());
    }

    public <T> T toBeanIgnoreCase(T bean) {
        return BeanKit.fillBeanWithMap(this, bean, CopyOptions.of().setIgnoreCase(true));
    }

    public <T> T toBean(Class<T> clazz) {
        return BeanKit.toBean(this, clazz);
    }

    public <T> T toBeanIgnoreCase(Class<T> clazz) {
        return BeanKit.toBean((Object)this, clazz, CopyOptions.of().setIgnoreCase(true));
    }

    public <T> Dictionary parseBean(T bean) {
        Assert.notNull(bean, "Bean must not be null", new Object[0]);
        this.putAll(BeanKit.beanToMap(bean, new String[0]));
        return this;
    }

    public <T> Dictionary parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        Assert.notNull(bean, "Bean must not be null", new Object[0]);
        this.putAll(BeanKit.beanToMap(bean, isToUnderlineCase, ignoreNullValue));
        return this;
    }

    public <T extends Dictionary> void removeEqual(T dict, String ... withoutNames) {
        HashSet<String> withoutSet = SetKit.of(withoutNames);
        for (Map.Entry entry : dict.entrySet()) {
            Object value;
            if (withoutSet.contains(entry.getKey()) || !Objects.equals(value = this.get(entry.getKey()), entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public Dictionary filterNew(String ... keys) {
        Dictionary result = new Dictionary(keys.length, 1.0f);
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return result;
    }

    public Dictionary removeNew(String ... keys) {
        return MapKit.removeAny(this.clone(), keys);
    }

    public Dictionary set(String attr, Object value) {
        this.put(attr, value);
        return this;
    }

    public Dictionary setIgnoreNull(String attr, Object value) {
        if (null != attr && null != value) {
            this.set(attr, value);
        }
        return this;
    }

    @Override
    public Object getObject(String key, Object defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    public <P, T> T get(FunctionX<P, T> func) {
        LambdaInfo lambdaInfo = LambdaKit.resolve(func);
        return this.get(lambdaInfo.getFieldName(), lambdaInfo.getReturnType());
    }

    public <T> T getBean(String attr) {
        return (T)this.get(attr);
    }

    public <T> T getByPath(String expression) {
        return (T)BeanPath.of(expression).getValue(this);
    }

    public <T> T getByPath(String expression, Type resultType) {
        return Convert.convert(resultType, this.getByPath(expression));
    }

    @Override
    public Dictionary clone() {
        try {
            return (Dictionary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneException(e);
        }
    }

    @Override
    protected String customKey(Object key) {
        if (this.caseInsensitive && null != key) {
            key = ((String)key).toLowerCase();
        }
        return (String)key;
    }

    public Dictionary setFields(SupplierX<?> ... fields) {
        Arrays.stream(fields).forEach((? super T f) -> this.set(LambdaKit.getFieldName(f), f.get()));
        return this;
    }
}

