/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec.binary;

import java.nio.charset.Charset;
import org.miaixz.bus.core.codec.binary.provider.Base32Provider;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.StringKit;

public class Base32 {
    public static String encode(byte[] bytes) {
        return Base32Provider.INSTANCE.encode(bytes);
    }

    public static String encode(String source) {
        return Base32.encode(source, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String encode(String source, Charset charset) {
        return Base32.encode(ByteKit.toBytes(source, charset));
    }

    public static String encodeHex(byte[] bytes) {
        return Base32Provider.INSTANCE.encode(bytes, true);
    }

    public static String encodeHex(String source) {
        return Base32.encodeHex(source, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String encodeHex(String source, Charset charset) {
        return Base32.encodeHex(ByteKit.toBytes(source, charset));
    }

    public static byte[] decode(String base32) {
        return Base32Provider.INSTANCE.decode(base32);
    }

    public static String decodeString(String source) {
        return Base32.decodeString(source, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String decodeString(String source, Charset charset) {
        return StringKit.toString(Base32.decode(source), charset);
    }

    public static byte[] decodeHex(String base32) {
        return Base32Provider.INSTANCE.decode(base32, true);
    }

    public static String decodeStrHex(String source) {
        return Base32.decodeStrHex(source, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String decodeStrHex(String source, Charset charset) {
        return StringKit.toString(Base32.decodeHex(source), charset);
    }
}

