/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec.binary;

import java.nio.charset.Charset;
import org.miaixz.bus.core.codec.binary.provider.Base16Provider;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.StringKit;

public class Hex {
    public static char[] encode(byte[] data) {
        return Hex.encode(data, true);
    }

    public static char[] encode(String text, Charset charset) {
        return Hex.encode(ByteKit.toBytes(text, charset), true);
    }

    public static char[] encode(byte[] data, boolean toLowerCase) {
        if (null == data) {
            return null;
        }
        return (toLowerCase ? Base16Provider.CODEC_LOWER : Base16Provider.CODEC_UPPER).encode(data);
    }

    public static String encodeString(byte[] data) {
        return Hex.encodeString(data, true);
    }

    public static String encodeString(String data) {
        return Hex.encodeString(data, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String encodeString(String data, Charset charset) {
        return Hex.encodeString(ByteKit.toBytes(data, charset), true);
    }

    public static String encodeString(byte[] data, boolean toLowerCase) {
        return StringKit.toString(Hex.encode(data, toLowerCase), org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String decodeString(String hexStr) {
        return Hex.decodeString(hexStr, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String decodeString(String hexStr, Charset charset) {
        if (StringKit.isEmpty(hexStr)) {
            return hexStr;
        }
        return StringKit.toString(Hex.decode(hexStr), charset);
    }

    public static String decodeString(char[] hexData, Charset charset) {
        return StringKit.toString(Hex.decode(hexData), charset);
    }

    public static byte[] decode(String hexStr) {
        return Hex.decode((CharSequence)hexStr);
    }

    public static byte[] decode(char[] hexData) {
        return Hex.decode(String.valueOf(hexData));
    }

    public static byte[] decode(CharSequence hexData) {
        return Base16Provider.CODEC_LOWER.decode(hexData);
    }
}

