/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec.binary.decoder;

import org.miaixz.bus.core.codec.Decoder;
import org.miaixz.bus.core.codec.binary.encoder.Base62Encoder;
import org.miaixz.bus.core.codec.binary.provider.Base62Provider;

public class Base62Decoder
implements Decoder<byte[], byte[]> {
    public static Base62Decoder GMP_DECODER = new Base62Decoder(Base62Encoder.GMP);
    public static Base62Decoder INVERTED_DECODER = new Base62Decoder(Base62Encoder.INVERTED);
    private final byte[] lookupTable = new byte[123];

    public Base62Decoder(byte[] alphabet) {
        for (int i = 0; i < alphabet.length; ++i) {
            this.lookupTable[alphabet[i]] = (byte)i;
        }
    }

    @Override
    public byte[] decode(byte[] encoded) {
        byte[] prepared = Base62Provider.translate(encoded, this.lookupTable);
        return Base62Provider.convert(prepared, 62, 256);
    }
}

