/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec.binary.encoder;

import java.util.Arrays;
import org.miaixz.bus.core.codec.Encoder;
import org.miaixz.bus.core.codec.binary.provider.Base58Provider;

public class Base58Encoder
implements Encoder<byte[], String> {
    public static final String DEFAULT_ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    public static final Base58Encoder ENCODER = new Base58Encoder("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray());
    private final char[] alphabet;
    private final char alphabetZero;

    public Base58Encoder(char[] alphabet) {
        this.alphabet = alphabet;
        this.alphabetZero = alphabet[0];
    }

    @Override
    public String encode(byte[] data) {
        int zeroCount;
        if (null == data) {
            return null;
        }
        if (data.length == 0) {
            return "";
        }
        for (zeroCount = 0; zeroCount < data.length && data[zeroCount] == 0; ++zeroCount) {
        }
        data = Arrays.copyOf(data, data.length);
        char[] encoded = new char[data.length * 2];
        int outputStart = encoded.length;
        int inputStart = zeroCount;
        while (inputStart < data.length) {
            encoded[--outputStart] = this.alphabet[Base58Provider.divmod(data, inputStart, 256, 58)];
            if (data[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < encoded.length && encoded[outputStart] == this.alphabetZero) {
            ++outputStart;
        }
        while (--zeroCount >= 0) {
            encoded[--outputStart] = this.alphabetZero;
        }
        return new String(encoded, outputStart, encoded.length - outputStart);
    }
}

