/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.util.function.Function;
import org.miaixz.bus.core.convert.AbstractConverter;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.convert.NumberConverter;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class PrimitiveConverter
extends AbstractConverter {
    public static final PrimitiveConverter INSTANCE = new PrimitiveConverter();
    private static final long serialVersionUID = -1L;

    protected static Object convert(Object value, Class<?> primitiveClass, Function<Object, String> toStringFunc) {
        if (Byte.TYPE == primitiveClass) {
            return ObjectKit.defaultIfNull(NumberConverter.convert(value, Byte.class, toStringFunc), 0);
        }
        if (Short.TYPE == primitiveClass) {
            return ObjectKit.defaultIfNull(NumberConverter.convert(value, Short.class, toStringFunc), 0);
        }
        if (Integer.TYPE == primitiveClass) {
            return ObjectKit.defaultIfNull(NumberConverter.convert(value, Integer.class, toStringFunc), 0);
        }
        if (Long.TYPE == primitiveClass) {
            return ObjectKit.defaultIfNull(NumberConverter.convert(value, Long.class, toStringFunc), 0);
        }
        if (Float.TYPE == primitiveClass) {
            return ObjectKit.defaultIfNull(NumberConverter.convert(value, Float.class, toStringFunc), 0);
        }
        if (Double.TYPE == primitiveClass) {
            return ObjectKit.defaultIfNull(NumberConverter.convert(value, Double.class, toStringFunc), 0);
        }
        if (Character.TYPE == primitiveClass) {
            return Convert.convert(Character.class, value);
        }
        if (Boolean.TYPE == primitiveClass) {
            return Convert.convert(Boolean.class, value);
        }
        throw new ConvertException("Unsupported target type: {}", primitiveClass);
    }

    @Override
    protected Object convertInternal(Class<?> targetClass, Object value) {
        return PrimitiveConverter.convert(value, targetClass, this::convertToString);
    }

    @Override
    protected String convertToString(Object value) {
        return StringKit.trim(super.convertToString(value));
    }
}

