/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.data;

import org.miaixz.bus.core.data.NanoId;
import org.miaixz.bus.core.data.ObjectId;
import org.miaixz.bus.core.data.Snowflake;
import org.miaixz.bus.core.data.UUID;
import org.miaixz.bus.core.instance.Instances;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.net.ip.IPv4;
import org.miaixz.bus.core.xyz.RuntimeKit;

public class ID {
    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public static String simpleUUID() {
        return UUID.randomUUID().toString(true);
    }

    public static String fastUUID() {
        return UUID.fastUUID().toString();
    }

    public static String fastSimpleUUID() {
        return UUID.fastUUID().toString(true);
    }

    public static String objectId() {
        return ObjectId.next();
    }

    public static Snowflake getSnowflake(long workerId, long datacenterId) {
        return Instances.get(Snowflake.class, workerId, datacenterId);
    }

    public static Snowflake getSnowflake(long workerId) {
        return Instances.get(Snowflake.class, workerId);
    }

    public static Snowflake getSnowflake() {
        return Instances.get(Snowflake.class, new Object[0]);
    }

    public static long getDataCenterId(long maxDatacenterId) {
        Assert.isTrue(maxDatacenterId > 0L, "maxDatacenterId must be > 0", new Object[0]);
        if (maxDatacenterId == Long.MAX_VALUE) {
            --maxDatacenterId;
        }
        long id = 1L;
        byte[] mac = null;
        try {
            mac = IPv4.getLocalHardwareAddress();
        }
        catch (InternalException internalException) {
            // empty catch block
        }
        if (null != mac) {
            id = (0xFFL & (long)mac[mac.length - 2] | 0xFF00L & (long)mac[mac.length - 1] << 8) >> 6;
            id %= maxDatacenterId + 1L;
        }
        return id;
    }

    public static long getWorkerId(long datacenterId, long maxWorkerId) {
        StringBuilder mpid = new StringBuilder();
        mpid.append(datacenterId);
        try {
            mpid.append(RuntimeKit.getPid());
        }
        catch (InternalException internalException) {
            // empty catch block
        }
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    public static String nanoId() {
        return NanoId.randomNanoId();
    }

    public static String nanoId(int size) {
        return NanoId.randomNanoId(size);
    }

    public static long getSnowflakeNextId() {
        return ID.getSnowflake().next();
    }

    public static String getSnowflakeNextIds() {
        return ID.getSnowflake().nextString();
    }
}

