/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io;

import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Predicate;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.ArrayKit;

public class ByteOrderMark
implements Predicate<byte[]>,
Comparable<ByteOrderMark>,
Serializable {
    public static final ByteOrderMark UTF_8 = new ByteOrderMark("UTF-8", -17, -69, -65);
    public static final ByteOrderMark UTF_16BE = new ByteOrderMark("UTF-16BE", -2, -1);
    public static final ByteOrderMark UTF_16LE = new ByteOrderMark("UTF-16LE", -1, -2);
    public static final ByteOrderMark UTF_32BE = new ByteOrderMark("UTF-32BE", 0, 0, -2, -1);
    public static final ByteOrderMark UTF_32LE = new ByteOrderMark("UTF-32LE", -1, -2, 0, 0);
    public static final ByteOrderMark[] ALL = new ByteOrderMark[]{UTF_32BE, UTF_32LE, UTF_8, UTF_16BE, UTF_16LE};
    private static final long serialVersionUID = -1L;
    private final String charsetName;
    private final byte[] bytes;

    public ByteOrderMark(String charsetName, byte ... bytes) {
        if (ArrayKit.isEmpty(bytes)) {
            throw new IllegalArgumentException("No bytes specified");
        }
        this.charsetName = Assert.notEmpty(charsetName, "No charsetName specified", new Object[0]);
        this.bytes = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public int length() {
        return this.bytes.length;
    }

    public int get(int pos) {
        return this.bytes[pos];
    }

    public byte[] getBytes() {
        return Arrays.copyOfRange(this.bytes, 0, this.bytes.length);
    }

    @Override
    public boolean test(byte[] headBytes) {
        if (headBytes.length < this.bytes.length) {
            return false;
        }
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == headBytes[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ByteOrderMark)) {
            return false;
        }
        ByteOrderMark bom = (ByteOrderMark)obj;
        return Arrays.equals(this.bytes, bom.bytes);
    }

    public int hashCode() {
        int hashCode = this.getClass().hashCode();
        for (byte b : this.bytes) {
            hashCode += b;
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append('[');
        builder.append(this.charsetName);
        builder.append(": ");
        for (int i = 0; i < this.bytes.length; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append("0x");
            builder.append(Integer.toHexString(0xFF & this.bytes[i]).toUpperCase());
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public int compareTo(ByteOrderMark o) {
        return Integer.compare(o.length(), this.length());
    }
}

