/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.compress;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.core.io.compress.ZipReader;
import org.miaixz.bus.core.io.compress.ZipWriter;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ZipReplacer
implements Closeable {
    private final ZipReader zipReader;
    private final boolean ignoreCase;
    private final Map<String, Resource> replacedResources = new HashMap<String, Resource>();

    public ZipReplacer(ZipReader zipReader, boolean ignoreCase) {
        this.zipReader = zipReader;
        this.ignoreCase = ignoreCase;
    }

    private static boolean isSamePath(String entryPath, String targetPath, boolean ignoreCase) {
        entryPath = StringKit.removePrefix(FileKit.normalize(entryPath), "/");
        targetPath = StringKit.removePrefix(FileKit.normalize(targetPath), "/");
        return StringKit.equals(entryPath, targetPath, ignoreCase);
    }

    public ZipReplacer addReplace(String entryPath, Resource resource) {
        this.replacedResources.put(entryPath, resource);
        return this;
    }

    public void write(ZipWriter writer) {
        this.zipReader.read(entry -> {
            for (String key : this.replacedResources.keySet()) {
                String entryName = entry.getName();
                if (ZipReplacer.isSamePath(entryName, key, this.ignoreCase)) {
                    writer.add(key, this.replacedResources.get(key).getStream());
                    continue;
                }
                writer.add(entryName, this.zipReader.get(entryName));
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.zipReader.close();
    }
}

