/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.file;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.miaixz.bus.core.center.function.ConsumerX;
import org.miaixz.bus.core.center.function.FunctionX;
import org.miaixz.bus.core.io.file.FileWrapper;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ExceptionKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;

public class FileReader
extends FileWrapper {
    private static final long serialVersionUID = -1L;

    public FileReader(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public static FileReader of(File file, Charset charset) {
        return new FileReader(file, charset);
    }

    public static FileReader of(File file) {
        return new FileReader(file, DEFAULT_CHARSET);
    }

    public byte[] readBytes() throws InternalException {
        try {
            return Files.readAllBytes(this.file.toPath());
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public String readString() throws InternalException {
        return new String(this.readBytes(), this.charset);
    }

    public <T extends Collection<String>> T readLines(T collection) throws InternalException {
        return this.readLines(collection, null);
    }

    public <T extends Collection<String>> T readLines(T collection, Predicate<String> predicate) throws InternalException {
        this.readLines(s -> {
            if (null == predicate || predicate.test((String)s)) {
                collection.add(s);
            }
        });
        return collection;
    }

    public void readLines(ConsumerX<String> lineHandler) throws InternalException {
        BufferedReader reader = null;
        try {
            reader = FileKit.getReader(this.file, this.charset);
            IoKit.readLines((Reader)reader, lineHandler);
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(reader);
            throw throwable;
        }
        IoKit.closeQuietly(reader);
    }

    public List<String> readLines() throws InternalException {
        return this.readLines(new ArrayList());
    }

    public <T> T read(FunctionX<BufferedReader, T> readerHandler) throws InternalException {
        T result;
        BufferedReader reader = null;
        try {
            reader = FileKit.getReader(this.file, this.charset);
            result = readerHandler.applying(reader);
        }
        catch (Throwable e) {
            try {
                throw ExceptionKit.wrapRuntime(e);
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly(reader);
                throw throwable;
            }
        }
        IoKit.closeQuietly(reader);
        return result;
    }

    public BufferedReader getReader() throws InternalException {
        return IoKit.toReader(this.getInputStream(), this.charset);
    }

    public BufferedInputStream getInputStream() throws InternalException {
        try {
            return new BufferedInputStream(Files.newInputStream(this.file.toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public long writeToStream(OutputStream out) throws InternalException {
        return this.writeToStream(out, false);
    }

    /*
     * Loose catch block
     */
    public long writeToStream(OutputStream out, boolean isCloseOut) throws InternalException {
        long l;
        FileInputStream in;
        block10: {
            in = new FileInputStream(this.file);
            l = IoKit.copy((InputStream)in, out);
            in.close();
            if (!isCloseOut) break block10;
            IoKit.closeQuietly(out);
        }
        return l;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new InternalException(e);
                    }
                }
                catch (Throwable throwable3) {
                    if (isCloseOut) {
                        IoKit.closeQuietly(out);
                    }
                    throw throwable3;
                }
            }
        }
    }

    private void checkFile() throws InternalException {
        if (!this.file.exists()) {
            throw new InternalException("File not exist: " + String.valueOf(this.file));
        }
        if (!this.file.isFile()) {
            throw new InternalException("Not a file:" + String.valueOf(this.file));
        }
    }
}

