/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.miaixz.bus.core.io.file.FileMagicNumber;
import org.miaixz.bus.core.io.file.FileName;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.HexKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;

public class FileType {
    private static final Map<String, String> FILE_TYPE_MAP = new ConcurrentSkipListMap<String, String>();

    public static String putFileType(String fileStreamHexHead, String extName) {
        return FILE_TYPE_MAP.put(fileStreamHexHead, extName);
    }

    public static String removeFileType(String fileStreamHexHead) {
        return FILE_TYPE_MAP.remove(fileStreamHexHead);
    }

    public static String getType(String fileStreamHexHead) {
        for (Map.Entry<String, String> fileTypeEntry : FILE_TYPE_MAP.entrySet()) {
            if (!StringKit.startWithIgnoreCase(fileStreamHexHead, fileTypeEntry.getKey())) continue;
            return fileTypeEntry.getValue();
        }
        byte[] bytes = HexKit.decode(fileStreamHexHead);
        return FileMagicNumber.getMagicNumber(bytes).getExtension();
    }

    public static String getType(InputStream in, int fileHeadSize) throws InternalException {
        return FileType.getType(IoKit.readHex(in, fileHeadSize, false));
    }

    public static String getType(InputStream in, boolean isExact) throws InternalException {
        if (null == in) {
            return null;
        }
        return isExact ? FileType.getType(FileType.readHex8192Upper(in)) : FileType.getType(FileType.readHex64Upper(in));
    }

    public static String getType(InputStream in) throws InternalException {
        return FileType.getType(in, false);
    }

    public static String getType(InputStream in, String filename) throws InternalException {
        return FileType.getType(in, filename, false);
    }

    public static String getType(InputStream in, String filename, boolean isExact) throws InternalException {
        String typeName = FileType.getType(in, isExact);
        if (null == typeName) {
            typeName = FileName.extName(filename);
        } else if ("zip".equals(typeName)) {
            String extName = FileName.extName(filename);
            if ("docx".equalsIgnoreCase(extName)) {
                typeName = "docx";
            } else if ("xlsx".equalsIgnoreCase(extName)) {
                typeName = "xlsx";
            } else if ("pptx".equalsIgnoreCase(extName)) {
                typeName = "pptx";
            } else if ("jar".equalsIgnoreCase(extName)) {
                typeName = "jar";
            } else if ("war".equalsIgnoreCase(extName)) {
                typeName = "war";
            } else if ("ofd".equalsIgnoreCase(extName)) {
                typeName = "ofd";
            } else if ("apk".equalsIgnoreCase(extName)) {
                typeName = "apk";
            }
        } else if ("jar".equals(typeName)) {
            String extName = FileName.extName(filename);
            if ("xlsx".equalsIgnoreCase(extName)) {
                typeName = "xlsx";
            } else if ("docx".equalsIgnoreCase(extName)) {
                typeName = "docx";
            } else if ("pptx".equalsIgnoreCase(extName)) {
                typeName = "pptx";
            } else if ("zip".equalsIgnoreCase(extName)) {
                typeName = "zip";
            } else if ("apk".equalsIgnoreCase(extName)) {
                typeName = "apk";
            }
        }
        return typeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getType(File file, boolean isExact) throws InternalException {
        String string;
        if (!FileKit.isFile(file)) {
            throw new IllegalArgumentException("Not a regular file!");
        }
        InputStream in = null;
        try {
            in = IoKit.toStream(file);
            string = FileType.getType(in, file.getName(), isExact);
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(in);
            throw throwable;
        }
        IoKit.closeQuietly(in);
        return string;
    }

    public static String getType(File file) throws InternalException {
        return FileType.getType(file, false);
    }

    public static String getTypeByPath(String path, boolean isExact) throws InternalException {
        return FileType.getType(FileKit.file(path), isExact);
    }

    public static String getTypeByPath(String path) throws InternalException {
        return FileType.getTypeByPath(path, false);
    }

    private static String readHex8192Upper(InputStream in) throws InternalException {
        try {
            return IoKit.readHex(in, Math.min(8192, in.available()), false);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    private static String readHex64Upper(InputStream in) throws InternalException {
        return IoKit.readHex(in, 64, false);
    }
}

